/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.user;

import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.powertac.visualizer.display.BrokerSeriesTemplate;
import org.powertac.visualizer.domain.broker.BrokerModel;
import org.powertac.visualizer.services.BrokerService;
import org.powertac.visualizer.services.handlers.VisualizerHelperService;
import org.powertac.visualizer.statistical.FinanceDynamicData;
import org.springframework.beans.factory.annotation.Autowired;

public class FinanceBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String financeDynData;
    private String financeDynDataOneTimeslot;

    @Autowired
    public FinanceBean(BrokerService brokerService, VisualizerHelperService helper) {
        ArrayList brokers = brokerService.getBrokers();
        Gson gson = new Gson();
        int safetyTsIndex = helper.getSafetyTimeslotIndex();
        ArrayList<BrokerSeriesTemplate> financeTxData = new ArrayList<BrokerSeriesTemplate>();
        ArrayList<BrokerSeriesTemplate> financeTxDataOneTimeslot = new ArrayList<BrokerSeriesTemplate>();
        for (BrokerModel brokerModel : brokers) {
            ArrayList<Object[]> profitData = new ArrayList<Object[]>();
            ArrayList<Object[]> profitDataOneTimeslot = new ArrayList<Object[]>();
            ConcurrentHashMap dynDataMap = brokerModel.getFinanceCategory().getFinanceDynamicDataMap();
            NavigableSet<Integer> dynDataSet = new TreeSet<Integer>(dynDataMap.keySet()).headSet(safetyTsIndex, true);
            Iterator iterator2 = dynDataSet.iterator();
            while (iterator2.hasNext()) {
                int key = (Integer)iterator2.next();
                FinanceDynamicData dynData = (FinanceDynamicData)dynDataMap.get(key);
                Object[] profit = new Object[]{helper.getMillisForIndex(key), dynData.getProfit()};
                profitData.add(profit);
                Object[] profitOneTimeslot = new Object[]{helper.getMillisForIndex(key), dynData.getProfitDelta()};
                profitDataOneTimeslot.add(profitOneTimeslot);
            }
            if (dynDataSet.size() == 0) {
                double[] dummy = new double[]{helper.getMillisForIndex(0), 0.0};
                profitData.add(dummy);
                profitDataOneTimeslot.add(dummy);
            }
            financeTxData.add(new BrokerSeriesTemplate(brokerModel.getName(), brokerModel.getAppearance().getColorCode(), 0, profitData, true));
            financeTxDataOneTimeslot.add(new BrokerSeriesTemplate(brokerModel.getName(), brokerModel.getAppearance().getColorCode(), 0, profitDataOneTimeslot, true));
        }
        this.financeDynData = gson.toJson(financeTxData);
        this.financeDynDataOneTimeslot = gson.toJson(financeTxDataOneTimeslot);
    }

    public String getFinanceDynData() {
        return this.financeDynData;
    }

    public String getFinanceDynDataOneTimeslot() {
        return this.financeDynDataOneTimeslot;
    }
}

