/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.user;

import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.powertac.common.enumerations.PowerType;
import org.powertac.visualizer.display.BrokerSeriesTemplate;
import org.powertac.visualizer.display.CustomerStatisticsTemplate;
import org.powertac.visualizer.display.DrillDownTemplate;
import org.powertac.visualizer.display.DrillDownTemplate2;
import org.powertac.visualizer.domain.broker.BrokerModel;
import org.powertac.visualizer.domain.broker.TariffData;
import org.powertac.visualizer.domain.broker.TariffDynamicData;
import org.powertac.visualizer.services.BrokerService;
import org.powertac.visualizer.services.handlers.VisualizerHelperService;
import org.powertac.visualizer.user.TariffMarketBean;
import org.springframework.beans.factory.annotation.Autowired;

public class TariffMarketBean
implements Serializable {
    private String tariffDynData;
    private String tariffDynDataOneTimeslot;
    private ArrayList<TariffData> allTarifs = new ArrayList();
    private String customerStatictics;
    private List<TariffData> filteredValue;
    private TariffData selectedTariff;

    @Autowired
    public TariffMarketBean(BrokerService brokerService, VisualizerHelperService helper) {
        Gson gson = new Gson();
        ArrayList<BrokerSeriesTemplate> tariffData = new ArrayList<BrokerSeriesTemplate>();
        ArrayList<BrokerSeriesTemplate> tariffDataOneTimeslot = new ArrayList<BrokerSeriesTemplate>();
        ArrayList<CustomerStatisticsTemplate> customerStaticticsArray = new ArrayList<CustomerStatisticsTemplate>();
        int safetyTsIndex = helper.getSafetyWholesaleTimeslotIndex();
        ArrayList brokers = brokerService.getBrokers();
        for (BrokerModel brokerModel : brokers) {
            long[] customerType = new long[]{0L, 0L, 0L};
            1 customerTypeSpecific = new /* Unavailable Anonymous Inner Class!! */;
            ArrayList<Object[]> customerNumberData = new ArrayList<Object[]>();
            ArrayList<Object[]> profitData = new ArrayList<Object[]>();
            ArrayList<Object[]> netKWhData = new ArrayList<Object[]>();
            ArrayList<DrillDownTemplate2> drillDataBroker = new ArrayList<DrillDownTemplate2>();
            Collection allTariffsData = brokerModel.getTariffCategory().getTariffData().values();
            for (TariffData td : allTariffsData) {
                if (td.getCustomers() <= 0L) continue;
                if (td.getSpec().getPowerType().isConsumption()) {
                    customerType[0] = customerType[0] + td.getCustomers();
                }
                if (td.getSpec().getPowerType().isProduction()) {
                    customerType[1] = customerType[1] + td.getCustomers();
                }
                if (td.getSpec().getPowerType().isStorage()) {
                    customerType[2] = customerType[2] + td.getCustomers();
                }
                customerTypeSpecific.put(td.getSpec().getPowerType(), (Long)customerTypeSpecific.get(td.getSpec().getPowerType()) + td.getCustomers());
            }
            ArrayList<PowerTypeTemplate> data_c = new ArrayList<PowerTypeTemplate>();
            data_c.add(new PowerTypeTemplate(this, "Consumption", ((Long)customerTypeSpecific.get(PowerType.CONSUMPTION)).longValue()));
            data_c.add(new PowerTypeTemplate(this, "Interruptible consumption", ((Long)customerTypeSpecific.get(PowerType.INTERRUPTIBLE_CONSUMPTION)).longValue()));
            data_c.add(new PowerTypeTemplate(this, "Thermal storage consumption", ((Long)customerTypeSpecific.get(PowerType.THERMAL_STORAGE_CONSUMPTION)).longValue()));
            ArrayList<PowerTypeTemplate> data_p = new ArrayList<PowerTypeTemplate>();
            data_p.add(new PowerTypeTemplate(this, "Production", ((Long)customerTypeSpecific.get(PowerType.PRODUCTION)).longValue()));
            data_p.add(new PowerTypeTemplate(this, "Chp production", ((Long)customerTypeSpecific.get(PowerType.CHP_PRODUCTION)).longValue()));
            data_p.add(new PowerTypeTemplate(this, "Fossil production", ((Long)customerTypeSpecific.get(PowerType.FOSSIL_PRODUCTION)).longValue()));
            data_p.add(new PowerTypeTemplate(this, "Run of river production", ((Long)customerTypeSpecific.get(PowerType.RUN_OF_RIVER_PRODUCTION)).longValue()));
            data_p.add(new PowerTypeTemplate(this, "Solar production", ((Long)customerTypeSpecific.get(PowerType.SOLAR_PRODUCTION)).longValue()));
            data_p.add(new PowerTypeTemplate(this, "Wind production", ((Long)customerTypeSpecific.get(PowerType.WIND_PRODUCTION)).longValue()));
            ArrayList<PowerTypeTemplate> data_s = new ArrayList<PowerTypeTemplate>();
            data_s.add(new PowerTypeTemplate(this, "Battery storage", ((Long)customerTypeSpecific.get(PowerType.BATTERY_STORAGE)).longValue()));
            data_s.add(new PowerTypeTemplate(this, "Electric vehicle", ((Long)customerTypeSpecific.get(PowerType.ELECTRIC_VEHICLE)).longValue()));
            data_s.add(new PowerTypeTemplate(this, "Pumped storage production", ((Long)customerTypeSpecific.get(PowerType.PUMPED_STORAGE_PRODUCTION)).longValue()));
            DrillDownTemplate2 dt2_c = new DrillDownTemplate2("Consumers", customerType[0], (Object)new DrillDown(this, "Specific", data_c));
            DrillDownTemplate2 dt2_p = new DrillDownTemplate2("Producers", customerType[1], (Object)new DrillDown(this, "Specific", data_p));
            DrillDownTemplate2 dt2_s = new DrillDownTemplate2("Storage", customerType[2], (Object)new DrillDown(this, "Specific", data_s));
            if (customerType[0] > 0L) {
                drillDataBroker.add(dt2_c);
            }
            if (customerType[1] > 0L) {
                drillDataBroker.add(dt2_p);
            }
            if (customerType[2] > 0L) {
                drillDataBroker.add(dt2_s);
            }
            DrillDownTemplate customerStatisticsBroker = new DrillDownTemplate(brokerModel.getName(), brokerModel.getAppearance().getColorCode(), drillDataBroker);
            ArrayList<Object[]> customerNumberDataOneTimeslot = new ArrayList<Object[]>();
            ArrayList<Object[]> profitDataOneTimeslot = new ArrayList<Object[]>();
            ArrayList<Object[]> kwhDataOneTimeslot = new ArrayList<Object[]>();
            ConcurrentHashMap tariffDynData = brokerModel.getTariffCategory().getTariffDynamicDataMap();
            NavigableSet<Integer> keysTariffDynData = new TreeSet<Integer>(brokerModel.getTariffCategory().getTariffDynamicDataMap().keySet()).headSet(safetyTsIndex, true);
            Iterator iterator2 = keysTariffDynData.iterator();
            while (iterator2.hasNext()) {
                int key = (Integer)iterator2.next();
                TariffDynamicData dynData = (TariffDynamicData)tariffDynData.get(key);
                Object[] timeCustomerCount = new Object[]{helper.getMillisForIndex(key), dynData.getCustomerCount()};
                Object[] profit = new Object[]{helper.getMillisForIndex(key), dynData.getDynamicData().getProfit()};
                Object[] netKWh = new Object[]{helper.getMillisForIndex(key), dynData.getDynamicData().getEnergy()};
                customerNumberData.add(timeCustomerCount);
                profitData.add(profit);
                netKWhData.add(netKWh);
                Object[] customerCountOneTimeslot = new Object[]{helper.getMillisForIndex(key), dynData.getCustomerCountDelta()};
                Object[] profitOneTimeslot = new Object[]{helper.getMillisForIndex(key), dynData.getDynamicData().getProfitDelta()};
                Object[] kWhOneTimeslot = new Object[]{helper.getMillisForIndex(key), dynData.getDynamicData().getEnergyDelta()};
                customerNumberDataOneTimeslot.add(customerCountOneTimeslot);
                profitDataOneTimeslot.add(profitOneTimeslot);
                kwhDataOneTimeslot.add(kWhOneTimeslot);
            }
            if (keysTariffDynData.size() == 0) {
                double[] dummy = new double[]{helper.getMillisForIndex(0), 0.0};
                customerNumberData.add(dummy);
                profitData.add(dummy);
                netKWhData.add(dummy);
                customerNumberDataOneTimeslot.add(dummy);
                profitDataOneTimeslot.add(dummy);
                kwhDataOneTimeslot.add(dummy);
            }
            tariffData.add(new BrokerSeriesTemplate(brokerModel.getName(), brokerModel.getAppearance().getColorCode(), 0, profitData, true));
            tariffData.add(new BrokerSeriesTemplate(brokerModel.getName(), brokerModel.getAppearance().getColorCode(), 1, netKWhData, false));
            tariffData.add(new BrokerSeriesTemplate(brokerModel.getName(), brokerModel.getAppearance().getColorCode(), 2, true, customerNumberData, false));
            tariffDataOneTimeslot.add(new BrokerSeriesTemplate(brokerModel.getName(), brokerModel.getAppearance().getColorCode(), 0, profitDataOneTimeslot, true));
            tariffDataOneTimeslot.add(new BrokerSeriesTemplate(brokerModel.getName(), brokerModel.getAppearance().getColorCode(), 1, kwhDataOneTimeslot, false));
            tariffDataOneTimeslot.add(new BrokerSeriesTemplate(brokerModel.getName(), brokerModel.getAppearance().getColorCode(), 2, true, customerNumberDataOneTimeslot, false));
            customerStaticticsArray.add(new CustomerStatisticsTemplate(brokerModel.getName(), brokerModel.getAppearance().getColorCode(), (long)brokerModel.getTariffCategory().getCustomerCount(), (Object)customerStatisticsBroker));
            for (TariffData data : brokerModel.getTariffCategory().getTariffData().values()) {
                this.allTarifs.add(data);
            }
        }
        this.tariffDynData = gson.toJson(tariffData);
        this.tariffDynDataOneTimeslot = gson.toJson(tariffDataOneTimeslot);
        this.customerStatictics = gson.toJson(customerStaticticsArray);
    }

    public String getTariffDynData() {
        return this.tariffDynData;
    }

    public String getTariffDynDataOneTimeslot() {
        return this.tariffDynDataOneTimeslot;
    }

    public ArrayList<TariffData> getAllTarifs() {
        return this.allTarifs;
    }

    public List<TariffData> getFilteredValue() {
        return this.filteredValue;
    }

    public void setFilteredValue(List<TariffData> filteredValue) {
        this.filteredValue = filteredValue;
    }

    public String getCustomerStatictics() {
        return this.customerStatictics;
    }

    public TariffData getSelectedTariff() {
        return this.selectedTariff;
    }

    public void setSelectedTariff(TariffData selectedTariff) {
        this.selectedTariff = selectedTariff;
    }
}

