/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain.broker;

import com.google.gson.Gson;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.powertac.common.CustomerInfo;
import org.powertac.common.Rate;
import org.powertac.common.TariffSpecification;
import org.powertac.common.TariffTransaction;
import org.powertac.visualizer.domain.broker.BrokerModel;
import org.powertac.visualizer.domain.broker.TariffCustomerStats;
import org.powertac.visualizer.domain.broker.TariffData;

public class TariffData {
    private Logger log = Logger.getLogger(TariffData.class);
    private BrokerModel broker;
    private TariffSpecification spec;
    private double profit;
    private double netKWh;
    private long customers;
    private String powerType;
    private String ratesGraph;
    Gson gson = new Gson();
    private ConcurrentHashMap<CustomerInfo, TariffCustomerStats> tariffCustomerStats;

    public TariffData(TariffSpecification spec, BrokerModel broker) {
        this.spec = spec;
        this.broker = broker;
        this.tariffCustomerStats = new ConcurrentHashMap(20, 0.75f, 1);
        this.powerType = spec.getPowerType().toString();
        this.createRatesGraph();
    }

    public double getNetKWh() {
        return Math.round(this.netKWh);
    }

    public long getCustomers() {
        return this.customers;
    }

    public double getProfit() {
        return Math.round(this.profit);
    }

    public BigDecimal getProfitInThousandsOfEuro() {
        return new BigDecimal(this.profit / 1000.0).setScale(2, RoundingMode.HALF_UP);
    }

    public TariffSpecification getSpec() {
        return this.spec;
    }

    public ConcurrentHashMap<CustomerInfo, TariffCustomerStats> getTariffCustomerStats() {
        return this.tariffCustomerStats;
    }

    public void processTariffTx(TariffTransaction tx) {
        this.profit += tx.getCharge();
        this.netKWh += tx.getKWh();
        if (tx.getCustomerInfo() != null) {
            this.tariffCustomerStats.putIfAbsent(tx.getCustomerInfo(), new TariffCustomerStats(tx.getCustomerInfo(), this.spec));
            ((TariffCustomerStats)this.tariffCustomerStats.get(tx.getCustomerInfo())).addAmounts(tx.getCharge(), tx.getKWh());
        }
    }

    public void setCustomers(long customers) {
        this.customers += customers;
    }

    public String getPowerType() {
        return this.powerType;
    }

    public BrokerModel getBroker() {
        return this.broker;
    }

    public BigDecimal getNetMWh() {
        return new BigDecimal(this.netKWh / 1000.0).setScale(2, RoundingMode.HALF_UP);
    }

    public String toString() {
        return this.tariffCustomerStats.toString();
    }

    private void createRatesGraph() {
        ArrayList<RatesGraphTemplate> series = new ArrayList<RatesGraphTemplate>();
        Calendar calendar = GregorianCalendar.getInstance();
        for (Rate rate : this.spec.getRates()) {
            Object[] end;
            Object[] start;
            ArrayList<Object[]> data;
            if (rate.getWeeklyBegin() != -1) {
                data = new ArrayList<Object[]>();
                calendar.clear();
                calendar.set(2007, 0, rate.getWeeklyBegin(), rate.getDailyBegin() >= 0 ? rate.getDailyBegin() + 1 : 0, 0, 0);
                start = new Object[]{calendar.getTimeInMillis(), rate.getMinValue() * 100.0};
                data.add(start);
                calendar.clear();
                calendar.set(2007, 0, rate.getWeeklyEnd() >= 0 ? rate.getWeeklyEnd() : rate.getWeeklyBegin(), rate.getDailyEnd() >= 0 ? rate.getDailyEnd() + 1 : 23, 0, 0);
                end = new Object[]{calendar.getTimeInMillis(), rate.getMinValue() * 100.0};
                data.add(end);
                series.add(new RatesGraphTemplate(this, data));
                continue;
            }
            if (rate.getDailyBegin() != -1 && rate.getDailyEnd() != -1) {
                data = new ArrayList();
                calendar.clear();
                calendar.set(2006, 0, 1, rate.getDailyBegin() + 1, 0, 0);
                start = new Object[]{calendar.getTimeInMillis(), rate.getMinValue() * 100.0};
                data.add(start);
                calendar.clear();
                calendar.set(2006, 0, 1, rate.getDailyEnd() + 1, 0, 0);
                end = new Object[]{calendar.getTimeInMillis(), rate.getMinValue() * 100.0};
                data.add(end);
                series.add(new RatesGraphTemplate(this, data));
                continue;
            }
            if (rate.getDailyBegin() == -1 && rate.getDailyEnd() == -1 && rate.getWeeklyBegin() == -1 && rate.getWeeklyEnd() == -1) {
                data = new ArrayList();
                calendar.clear();
                calendar.set(2007, 0, 1, 1, 0, 0);
                start = new Object[]{calendar.getTimeInMillis(), rate.getMinValue() * 100.0};
                data.add(start);
                calendar.clear();
                calendar.set(2007, 0, 7, 1, 0, 0);
                end = new Object[]{calendar.getTimeInMillis(), rate.getMinValue() * 100.0};
                data.add(end);
                series.add(new RatesGraphTemplate(this, data));
                continue;
            }
            this.log.info((Object)"NO template in TariffData!");
        }
        this.ratesGraph = this.gson.toJson(series);
    }

    public String getRatesGraph() {
        return this.ratesGraph;
    }
}

