/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain.wholesale;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.powertac.common.ClearedTrade;
import org.powertac.common.Order;
import org.powertac.common.Timeslot;
import org.powertac.visualizer.Helper;
import org.powertac.visualizer.domain.wholesale.VisualizerOrderbook;
import org.powertac.visualizer.domain.wholesale.VisualizerOrderbookOrder;
import org.powertac.visualizer.json.WholesaleSnapshotJSON;
import org.primefaces.json.JSONArray;
import org.primefaces.json.JSONException;

public class WholesaleSnapshot {
    private static final int MARKET_PRICE = 100;
    Logger log = Logger.getLogger((String)WholesaleSnapshot.class.getName());
    private int timeslotSerialNumberCreated;
    private long millisCreated;
    private int timeslotSerialNumber;
    private Timeslot timeslot;
    private double totalTradedQuantity;
    private WholesaleSnapshotJSON wholesaleSnapshotJSON;
    private VisualizerOrderbook orders;
    private ClearedTrade clearedTrade;
    private VisualizerOrderbook orderbook;
    private boolean closed;
    private boolean cleared;
    private VisualizerOrderbookOrder marketAskOrder;
    private VisualizerOrderbookOrder marketBidOrder;
    private List<VisualizerOrderbookOrder> beforeAsks;
    private List<VisualizerOrderbookOrder> beforeBids;
    private List<VisualizerOrderbookOrder> afterAsks;
    private List<VisualizerOrderbookOrder> afterBids;

    public WholesaleSnapshot(long millisCreated, Timeslot timeslot, int timeslotSerialNumberCreated) {
        this.timeslotSerialNumber = timeslot.getSerialNumber();
        this.orders = new VisualizerOrderbook(timeslot, null, null);
        this.timeslot = timeslot;
        this.timeslotSerialNumberCreated = timeslotSerialNumberCreated;
        this.millisCreated = millisCreated;
    }

    public void addOrder(Order order) {
        VisualizerOrderbookOrder orderbookOrder = new VisualizerOrderbookOrder(order.getMWh().doubleValue(), order.getLimitPrice());
        if (order.getMWh() > 0.0) {
            if (order.getLimitPrice() == null) {
                this.marketBidOrder = orderbookOrder;
            } else {
                this.orders.addBid(orderbookOrder);
            }
        } else if (order.getLimitPrice() == null) {
            this.marketAskOrder = orderbookOrder;
        } else {
            this.orders.addAsk(orderbookOrder);
        }
    }

    public VisualizerOrderbook getOrders() {
        return this.orders;
    }

    public void setOrders(VisualizerOrderbook orders) {
        this.orders = orders;
    }

    public ClearedTrade getClearedTrade() {
        return this.clearedTrade;
    }

    public void setClearedTrade(ClearedTrade clearedTrade) {
        this.clearedTrade = clearedTrade;
        this.cleared = true;
    }

    public VisualizerOrderbook getOrderbook() {
        return this.orderbook;
    }

    public void setOrderbook(VisualizerOrderbook orderbook) {
        this.orderbook = orderbook;
    }

    public Timeslot getTimeslot() {
        return this.timeslot;
    }

    public WholesaleSnapshotJSON getWholesaleSnapshotJSON() {
        return this.wholesaleSnapshotJSON;
    }

    public String toString() {
        SortedSet bids;
        SortedSet asks;
        StringBuilder builder = new StringBuilder();
        builder.append("____________ORDERS:________\n");
        if (this.orders != null) {
            builder.append("ASKS:\n");
            asks = this.orders.getAsks();
            for (VisualizerOrderbookOrder orderbookOrder : asks) {
                builder.append(orderbookOrder).append("\n");
            }
            builder.append("ORDERS:\nBIDS:");
            bids = this.orders.getBids();
            for (VisualizerOrderbookOrder orderbookOrder : bids) {
                builder.append(orderbookOrder).append("\n");
            }
            if (this.marketAskOrder != null) {
                builder.append("MARKET ASK ORDER:\n");
                builder.append(this.marketAskOrder).append("\n");
            }
            if (this.marketBidOrder != null) {
                builder.append("MARKET BID ORDER:\n");
                builder.append(this.marketBidOrder).append("\n");
            }
        }
        builder.append("____________ORDERBOOK:________\n");
        if (this.orderbook != null) {
            builder.append("ASKS:\n");
            asks = this.orderbook.getAsks();
            for (VisualizerOrderbookOrder orderbookOrder : asks) {
                builder.append(orderbookOrder).append("\n");
            }
            builder.append("BIDS:\n");
            bids = this.orderbook.getBids();
            for (VisualizerOrderbookOrder orderbookOrder : bids) {
                builder.append(orderbookOrder).append("\n");
            }
        }
        return "" + builder + "\n\n" + this.clearedTrade;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getTimeslotSerialNumber() {
        return this.timeslotSerialNumber;
    }

    public void close() {
        this.finish();
        this.closed = true;
    }

    private void finish() {
        TreeSet bidsAfter;
        TreeSet asksAfter;
        if (this.clearedTrade != null) {
            this.totalTradedQuantity = Helper.roundNumberTwoDecimal((double)this.clearedTrade.getExecutionMWh());
        }
        JSONArray graphDataBeforeClearing = new JSONArray();
        JSONArray seriesColorsBeforeClearing = new JSONArray();
        SortedSet asks = this.orders.getAsks();
        SortedSet bids = this.orders.getBids();
        this.modifyMarketOrders();
        this.buildBeforeData(asks, bids, graphDataBeforeClearing, seriesColorsBeforeClearing);
        JSONArray graphDataAfterClearing = new JSONArray();
        JSONArray seriesColorsAfterClearing = new JSONArray();
        if (null != this.orderbook) {
            asksAfter = this.orderbook.getAsks();
            bidsAfter = this.orderbook.getBids();
        } else {
            this.log.warn((Object)"orderbook is null");
            asksAfter = new TreeSet();
            bidsAfter = new TreeSet();
        }
        this.buildAfterData(asksAfter, bidsAfter, graphDataAfterClearing, seriesColorsAfterClearing);
        this.wholesaleSnapshotJSON = new WholesaleSnapshotJSON(graphDataBeforeClearing, seriesColorsBeforeClearing, graphDataAfterClearing, seriesColorsAfterClearing);
        this.log.debug((Object)("Snapshot " + this.getTimeslotSerialNumber() + "@" + this.getTimeslotSerialNumberCreated() + " is closed: \n" + this.toString()));
        this.beforeAsks = new ArrayList(this.orders.getAsks());
        this.beforeBids = new ArrayList(this.orders.getBids());
        if (null != this.orderbook) {
            this.afterAsks = new ArrayList(this.orderbook.getAsks());
            this.afterBids = new ArrayList(this.orderbook.getBids());
        } else {
            this.afterAsks = new ArrayList();
            this.afterBids = new ArrayList();
        }
    }

    private void modifyMarketOrders() {
        double newPrice;
        SortedSet asks = this.orders.getAsks();
        SortedSet bids = this.orders.getBids();
        VisualizerOrderbookOrder lowestAsk = null;
        VisualizerOrderbookOrder highestAsk = null;
        VisualizerOrderbookOrder lowestBid = null;
        VisualizerOrderbookOrder highestBid = null;
        if (!asks.isEmpty()) {
            lowestAsk = (VisualizerOrderbookOrder)asks.first();
            highestAsk = (VisualizerOrderbookOrder)asks.last();
        }
        if (!bids.isEmpty()) {
            highestBid = (VisualizerOrderbookOrder)bids.first();
            lowestBid = (VisualizerOrderbookOrder)bids.last();
        }
        if (this.marketAskOrder != null) {
            newPrice = highestBid != null && lowestAsk != null ? (Math.abs(highestBid.getLimitPrice()) < Math.abs(lowestAsk.getLimitPrice()) ? 0.8 * Math.abs(highestBid.getLimitPrice()) : 0.8 * Math.abs(lowestAsk.getLimitPrice())) : 100.0;
            this.marketAskOrder = new VisualizerOrderbookOrder(this.marketAskOrder.getMWh(), Double.valueOf(newPrice));
        }
        if (this.marketBidOrder != null) {
            newPrice = lowestBid != null && highestAsk != null ? (Math.abs(lowestBid.getLimitPrice()) > Math.abs(highestAsk.getLimitPrice()) ? -1.2 * Math.abs(lowestBid.getLimitPrice()) : -1.2 * Math.abs(highestAsk.getLimitPrice())) : -100.0;
            this.marketBidOrder = new VisualizerOrderbookOrder(this.marketBidOrder.getMWh(), Double.valueOf(newPrice));
        }
    }

    private void buildAfterData(SortedSet<VisualizerOrderbookOrder> asksAfter, SortedSet<VisualizerOrderbookOrder> bidsAfter, JSONArray graphDataAfterClearing, JSONArray seriesColorsAfterClearing) {
        double clearedTradeOffset = 0.0;
        if (this.clearedTrade != null) {
            clearedTradeOffset = this.buildLine(Math.abs(this.clearedTrade.getExecutionMWh()), Math.abs(this.clearedTrade.getExecutionPrice()), graphDataAfterClearing, seriesColorsAfterClearing, 0.0, WholesaleSnapshotJSON.getClearedTradeColor());
        }
        double askOffset = clearedTradeOffset;
        for (VisualizerOrderbookOrder orderbookOrder : asksAfter) {
            if (orderbookOrder.getLimitPrice() == null) {
                VisualizerOrderbookOrder newMarketAskOrder = this.modifyMarketOrder(orderbookOrder, asksAfter);
                askOffset = this.buildLine(Math.abs(newMarketAskOrder.getMWh()), Math.abs(newMarketAskOrder.getLimitPrice()), graphDataAfterClearing, seriesColorsAfterClearing, askOffset, WholesaleSnapshotJSON.getMarketAskOrderColor());
                continue;
            }
            askOffset = this.buildLine(Math.abs(orderbookOrder.getMWh()), Math.abs(orderbookOrder.getLimitPrice()), graphDataAfterClearing, seriesColorsAfterClearing, askOffset, WholesaleSnapshotJSON.getLimitAskOrderColor());
        }
        double bidOffset = clearedTradeOffset;
        for (VisualizerOrderbookOrder orderbookOrder : bidsAfter) {
            if (orderbookOrder.getLimitPrice() == null) {
                VisualizerOrderbookOrder newMarketAskOrder = this.modifyMarketOrder(orderbookOrder, bidsAfter);
                bidOffset = this.buildLine(Math.abs(newMarketAskOrder.getMWh()), Math.abs(newMarketAskOrder.getLimitPrice()), graphDataAfterClearing, seriesColorsAfterClearing, bidOffset, WholesaleSnapshotJSON.getMarketBidOrderColor());
                continue;
            }
            bidOffset = this.buildLine(Math.abs(orderbookOrder.getMWh()), Math.abs(orderbookOrder.getLimitPrice()), graphDataAfterClearing, seriesColorsAfterClearing, bidOffset, WholesaleSnapshotJSON.getLimitBidOrderColor());
        }
    }

    private void buildBeforeData(SortedSet<VisualizerOrderbookOrder> asks, SortedSet<VisualizerOrderbookOrder> bids, JSONArray graphData, JSONArray seriesColors) {
        double askOffset = 0.0;
        if (this.marketAskOrder != null) {
            askOffset = this.buildLine(Math.abs(this.marketAskOrder.getMWh()), Math.abs(this.marketAskOrder.getLimitPrice()), graphData, seriesColors, askOffset, WholesaleSnapshotJSON.getMarketAskOrderColor());
        }
        for (VisualizerOrderbookOrder orderbookOrder : asks) {
            askOffset = this.buildLine(Math.abs(orderbookOrder.getMWh()), Math.abs(orderbookOrder.getLimitPrice()), graphData, seriesColors, askOffset, WholesaleSnapshotJSON.getLimitAskOrderColor());
        }
        double bidOffset = 0.0;
        if (this.marketBidOrder != null) {
            bidOffset = this.buildLine(Math.abs(this.marketBidOrder.getMWh()), Math.abs(this.marketBidOrder.getLimitPrice()), graphData, seriesColors, bidOffset, WholesaleSnapshotJSON.getMarketBidOrderColor());
        }
        for (VisualizerOrderbookOrder orderbookOrder : bids) {
            bidOffset = this.buildLine(Math.abs(orderbookOrder.getMWh()), Math.abs(orderbookOrder.getLimitPrice()), graphData, seriesColors, bidOffset, WholesaleSnapshotJSON.getLimitBidOrderColor());
        }
    }

    private VisualizerOrderbookOrder modifyMarketOrder(VisualizerOrderbookOrder marketOrder, SortedSet<VisualizerOrderbookOrder> offers) {
        try {
            VisualizerOrderbookOrder first = offers.first();
            Double limitPrice = first.getLimitPrice();
            double newMarketPrice = limitPrice == null ? (first.getMWh() > 0.0 ? -100.0 : 100.0) : (first.getMWh() > 0.0 ? -1.2 * limitPrice : 0.8 * limitPrice);
            return new VisualizerOrderbookOrder(marketOrder.getMWh(), Double.valueOf(newMarketPrice));
        }
        catch (NoSuchElementException e) {
            this.log.debug((Object)"market order is forever alone.");
            return new VisualizerOrderbookOrder(marketOrder.getMWh(), Double.valueOf(0.0));
        }
    }

    private double buildLine(double x, double y, JSONArray graphData, JSONArray seriesColors, double offset, String color) {
        try {
            double leftX_Axis = offset;
            JSONArray lineData = new JSONArray();
            JSONArray leftCoordData = new JSONArray();
            JSONArray rightCoordData = new JSONArray();
            leftCoordData.put(leftX_Axis).put(y);
            rightCoordData.put(offset += x).put(y);
            lineData.put((Object)leftCoordData).put((Object)rightCoordData);
            graphData.put((Object)lineData);
            seriesColors.put((Object)color);
            return offset;
        }
        catch (JSONException e) {
            this.log.warn((Object)"Building JSON Array failed.");
            return 0.0;
        }
    }

    public String getName() {
        return "Snapshot" + this.timeslotSerialNumberCreated;
    }

    public String getType() {
        return "Wholsale snapshot";
    }

    public String getTotalTradedQuantity() {
        return "" + this.totalTradedQuantity;
    }

    public int getTimeslotSerialNumberCreated() {
        return this.timeslotSerialNumberCreated;
    }

    public VisualizerOrderbookOrder getMarketAskOrder() {
        return this.marketAskOrder;
    }

    public VisualizerOrderbookOrder getMarketBidOrder() {
        return this.marketBidOrder;
    }

    public List<VisualizerOrderbookOrder> getAfterAsks() {
        return this.afterAsks;
    }

    public List<VisualizerOrderbookOrder> getAfterBids() {
        return this.afterBids;
    }

    public List<VisualizerOrderbookOrder> getBeforeAsks() {
        return this.beforeAsks;
    }

    public List<VisualizerOrderbookOrder> getBeforeBids() {
        return this.beforeBids;
    }

    public long getMillisCreated() {
        return this.millisCreated;
    }

    public boolean isCleared() {
        return this.cleared;
    }
}

