/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services;

import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.MarketTransaction;
import org.powertac.visualizer.beans.VisualizerBean;
import org.powertac.visualizer.domain.broker.BrokerModel;
import org.powertac.visualizer.domain.broker.TariffDynamicData;
import org.powertac.visualizer.interfaces.Recyclable;
import org.powertac.visualizer.interfaces.TimeslotCompleteActivation;
import org.powertac.visualizer.push.DynDataPusher;
import org.powertac.visualizer.push.FinancePusher;
import org.powertac.visualizer.push.NominationCategoryPusher;
import org.powertac.visualizer.push.NominationPusher;
import org.powertac.visualizer.push.TariffMarketPusher;
import org.powertac.visualizer.push.WholesaleMarketPusher;
import org.powertac.visualizer.services.BrokerService;
import org.powertac.visualizer.services.GradingService;
import org.powertac.visualizer.services.handlers.VisualizerHelperService;
import org.powertac.visualizer.statistical.BalancingCategory;
import org.powertac.visualizer.statistical.DistributionCategory;
import org.powertac.visualizer.statistical.DynamicData;
import org.powertac.visualizer.statistical.FinanceCategory;
import org.powertac.visualizer.statistical.FinanceDynamicData;
import org.powertac.visualizer.statistical.TariffCategory;
import org.powertac.visualizer.statistical.WholesaleCategory;
import org.primefaces.push.PushContext;
import org.primefaces.push.PushContextFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BrokerService
implements TimeslotCompleteActivation,
Recyclable,
Serializable {
    private static final long serialVersionUID = 15L;
    private ConcurrentHashMap<String, BrokerModel> brokersMap;
    private ArrayList<BrokerModel> brokers;
    @Autowired
    private VisualizerBean visualizerBean;
    @Autowired
    private VisualizerHelperService helper;
    @Autowired
    GradingService gradingBean;
    private static Logger log = Logger.getLogger(BrokerService.class);
    private final int TIMESLOTS_TO_DISPLAY = 48;

    public BrokerService() {
        this.recycle();
    }

    public ConcurrentHashMap<String, BrokerModel> getBrokersMap() {
        return this.brokersMap;
    }

    public void setBrokers(ArrayList<BrokerModel> brokers) {
        this.brokers = brokers;
    }

    public void setBrokersMap(ConcurrentHashMap<String, BrokerModel> brokersMap) {
        this.brokersMap = brokersMap;
    }

    public BrokerModel findBrokerByName(String name) {
        return (BrokerModel)this.brokersMap.get(name);
    }

    public void recycle() {
        this.brokersMap = new ConcurrentHashMap();
        this.brokers = new ArrayList();
    }

    public void activate(int timeslotIndex, Instant postedTime) {
        PushContext pushContext = PushContextFactory.getDefault().getPushContext();
        Gson gson = new Gson();
        ArrayList<TariffMarketPusher> tariffMarketPushers = new ArrayList<TariffMarketPusher>();
        ArrayList<WholesaleMarketPusher> wholesaleMarketPushers = new ArrayList<WholesaleMarketPusher>();
        ArrayList<DynDataPusher> balancingMarketPushers = new ArrayList<DynDataPusher>();
        ArrayList<DynDataPusher> distributionPushers = new ArrayList<DynDataPusher>();
        ArrayList<FinancePusher> financePushers = new ArrayList<FinancePusher>();
        ArrayList allWholesaleData = new ArrayList();
        ArrayList brokersOverview = new ArrayList();
        NominationPusher np = null;
        for (BrokerModel b : this.brokers) {
            ArrayList wholesaleTxBrokerData = new ArrayList();
            ArrayList<Double> brokerOverview = new ArrayList<Double>();
            TariffCategory tc = b.getTariffCategory();
            TariffDynamicData tdd = tc.getLastTariffDynamicData();
            TariffMarketPusher tp = new TariffMarketPusher(b.getName(), this.helper.getMillisForIndex(tdd.getDynamicData().getTsIndex()), tdd.getDynamicData().getProfit(), tdd.getDynamicData().getEnergy(), tdd.getCustomerCount(), tdd.getDynamicData().getProfitDelta(), tdd.getDynamicData().getEnergyDelta(), tdd.getCustomerCountDelta());
            tariffMarketPushers.add(tp);
            int safetyTxIndex = timeslotIndex - 1;
            WholesaleCategory wc = b.getWholesaleCategory();
            wc.updateAccounts(safetyTxIndex);
            ConcurrentHashMap mtxMap = wc.getMarketTxs();
            NavigableSet<Integer> mtxSortedSet = new TreeSet<Integer>(wc.getMarketTxs().keySet()).headSet(safetyTxIndex, true);
            if (safetyTxIndex < 0) {
                return;
            }
            SortedSet<Integer> mtxSortedSetSubset = mtxSortedSet.subSet(safetyTxIndex - 48 < 0 ? 0 : safetyTxIndex - 48, safetyTxIndex);
            Iterator iterator2 = mtxSortedSetSubset.iterator();
            while (iterator2.hasNext()) {
                int key = (Integer)iterator2.next();
                List mtxList = (List)mtxMap.get(key);
                for (MarketTransaction marketTransaction : mtxList) {
                    ArrayList<Double> transaction = new ArrayList<Double>();
                    transaction.add(marketTransaction.getPrice());
                    transaction.add(marketTransaction.getMWh());
                    wholesaleTxBrokerData.add(transaction);
                }
            }
            allWholesaleData.add(wholesaleTxBrokerData);
            double profitDelta = 0.0;
            double profit = 0.0;
            double energy = 0.0;
            double energyDelta = 0.0;
            int timeslot = 0;
            NavigableSet<Integer> safeKeys = new TreeSet<Integer>(wc.getDynamicDataMap().keySet()).headSet(safetyTxIndex, true);
            if (!safeKeys.isEmpty()) {
                DynamicData lastWholesaledd = (DynamicData)wc.getDynamicDataMap().get(safeKeys.last());
                profitDelta = lastWholesaledd.getProfitDelta();
                energyDelta = lastWholesaledd.getEnergyDelta();
                profit = lastWholesaledd.getProfit();
                energy = lastWholesaledd.getEnergy();
                timeslot = lastWholesaledd.getTsIndex();
                WholesaleMarketPusher wmp = new WholesaleMarketPusher(b.getName(), this.helper.getMillisForIndex(timeslot), profitDelta, energyDelta, profit, energy);
                wholesaleMarketPushers.add(wmp);
            }
            BalancingCategory bc = b.getBalancingCategory();
            DynamicData bdd = bc.getLastDynamicData();
            DynDataPusher bddp = new DynDataPusher(b.getName(), this.helper.getMillisForIndex(bdd.getTsIndex()), bdd.getProfit(), bdd.getEnergy(), bdd.getProfitDelta(), bdd.getEnergyDelta());
            balancingMarketPushers.add(bddp);
            DistributionCategory dc = b.getDistributionCategory();
            DynamicData ddd = dc.getLastDynamicData();
            DynDataPusher dddp = new DynDataPusher(b.getName(), this.helper.getMillisForIndex(ddd.getTsIndex()), ddd.getProfit(), ddd.getEnergy(), ddd.getProfitDelta(), ddd.getEnergyDelta());
            distributionPushers.add(dddp);
            FinanceCategory fc = b.getFinanceCategory();
            FinanceDynamicData fdd = fc.getLastFinanceDynamicData();
            FinancePusher fp = new FinancePusher(b.getName(), this.helper.getMillisForIndex(fdd.getTsIndex()), fdd.getProfit(), fdd.getProfitDelta());
            financePushers.add(fp);
            brokerOverview.add(this.gradingBean.getTariffGrade(tc.getTotalMoneyFlow(), tc.getConsumptionConsumers(), tc.getTotalMoneyFromSold(), tc.getTotalBoughtEnergy(), tc.getTotalSoldEnergy(), tc.getCustomerCount(), tc.getLostCustomers()));
            WholesaleCategory wcat = b.getWholesaleCategory();
            brokerOverview.add(this.gradingBean.getWholesaleGrade(wcat.getTotalRevenueFromSelling(), wcat.getTotalCostFromBuying(), wcat.getTotalEnergyBought(), wcat.getTotalEnergySold()));
            brokerOverview.add(this.gradingBean.getBalancingGrade(b.getBalancingCategory().getEnergy(), b.getDistributionCategory().getLastDynamicData().getEnergy(), b.getBalancingCategory().getProfit()));
            brokerOverview.add(this.gradingBean.getDistributionGrade(b.getDistributionCategory().getLastDynamicData().getEnergy()));
            brokersOverview.add(brokerOverview);
            if (np == null) {
                np = new NominationPusher(new NominationCategoryPusher(b.getName(), (long)fc.getProfit()), new NominationCategoryPusher(b.getName(), (long)Math.abs(bc.getEnergy())), new NominationCategoryPusher(b.getName(), (long)tc.getCustomerCount()));
                continue;
            }
            long profitAmount = (long)fc.getProfit();
            long balanceAmount = (long)Math.abs(bc.getEnergy());
            long customerAmount = tc.getCustomerCount();
            if (profitAmount > np.getProfit().getAmount()) {
                np.setProfit(new NominationCategoryPusher(b.getName(), profitAmount));
            }
            if (balanceAmount < Math.abs(np.getBalance().getAmount())) {
                np.setBalance(new NominationCategoryPusher(b.getName(), balanceAmount));
            }
            if (customerAmount <= np.getCustomerNumber().getAmount()) continue;
            np.setCustomerNumber(new NominationCategoryPusher(b.getName(), customerAmount));
        }
        if (np != null) {
            this.visualizerBean.setNominationPusher(np);
        }
        pushContext.push("/tariffpush", (Object)gson.toJson(tariffMarketPushers));
        pushContext.push("/wholesalemarketpush", (Object)gson.toJson(wholesaleMarketPushers));
        pushContext.push("/balancingmarketpush", (Object)gson.toJson(balancingMarketPushers));
        pushContext.push("/distributionpush", (Object)gson.toJson(distributionPushers));
        pushContext.push("/financepush", (Object)gson.toJson(financePushers));
        pushContext.push("/markettransactionepush", (Object)gson.toJson(allWholesaleData));
        pushContext.push("/gameoverview", (Object)gson.toJson(brokersOverview));
        pushContext.push("/ranking", (Object)this.getRanking());
    }

    public ArrayList<BrokerModel> getBrokers() {
        return this.brokers;
    }

    public int getNumberOfBrokers() {
        return this.brokers.size();
    }

    public ArrayList<String> getBrokerNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this.brokers.size(); ++i) {
            names.add("'" + ((BrokerModel)this.brokers.get(i)).getName() + "'");
        }
        return names;
    }

    public String getRanking() {
        HashMap<Integer, Double> map = new HashMap<Integer, Double>();
        for (int i = 0; i < this.brokers.size(); ++i) {
            map.put(i, ((BrokerModel)this.brokers.get(i)).getFinanceCategory().getProfit());
        }
        ValueComparator bvc = new ValueComparator(this, map);
        TreeMap<Integer, Double> sorted_map = new TreeMap<Integer, Double>((Comparator<Integer>)bvc);
        sorted_map.putAll(map);
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (int j = 0; j < sorted_map.size(); ++j) {
            int brokerID = (Integer)sorted_map.keySet().toArray()[j];
            TariffDynamicData tdd = ((BrokerModel)this.brokers.get(brokerID)).getTariffCategory().getLastTariffDynamicData();
            NavigableSet<Integer> safeKeys = new TreeSet<Integer>(((BrokerModel)this.brokers.get(brokerID)).getWholesaleCategory().getDynamicDataMap().keySet()).headSet(this.helper.getSafetyTimeslotIndex(), true);
            double profitDelta = 0.0;
            double energyDelta = 0.0;
            if (!safeKeys.isEmpty()) {
                DynamicData lastWholesaledd = (DynamicData)((BrokerModel)this.brokers.get(brokerID)).getWholesaleCategory().getDynamicDataMap().get(safeKeys.last());
                profitDelta = lastWholesaledd.getProfitDelta();
                energyDelta = lastWholesaledd.getEnergyDelta();
            }
            int customerDelta = tdd.getCustomerCount();
            Object[] pair = new Object[]{sorted_map.keySet().toArray()[j], sorted_map.values().toArray()[j], customerDelta, tdd.getDynamicData().getTsIndex(), tdd.getDynamicData().getEnergyDelta(), tdd.getDynamicData().getProfitDelta(), tdd.getDynamicData().getTsIndex() != this.helper.getSafetyTimeslotIndex() ? 0 : tdd.getCustomerCountDelta(), profitDelta, energyDelta};
            result.add(pair);
        }
        Gson gson = new Gson();
        return gson.toJson(result);
    }

    public ArrayList<Double> getEnergyDelta() {
        ArrayList<Double> energy = new ArrayList<Double>();
        for (int i = 0; i < this.brokers.size(); ++i) {
            energy.add(((BrokerModel)this.brokers.get(i)).getTariffCategory().getLastTariffDynamicData().getDynamicData().getEnergyDelta());
        }
        return energy;
    }

    public ArrayList<Double> getRevenueDelta() {
        ArrayList<Double> revenue = new ArrayList<Double>();
        for (int i = 0; i < this.brokers.size(); ++i) {
            revenue.add(((BrokerModel)this.brokers.get(i)).getTariffCategory().getLastTariffDynamicData().getDynamicData().getProfitDelta());
        }
        return revenue;
    }

    public ArrayList<Integer> getCustomersDelta() {
        ArrayList<Integer> customers = new ArrayList<Integer>();
        for (int i = 0; i < this.brokers.size(); ++i) {
            customers.add(((BrokerModel)this.brokers.get(i)).getTariffCategory().getLastTariffDynamicData().getCustomerCountDelta());
        }
        return customers;
    }

    public ArrayList<Double> getWholesaleEnergyDelta() {
        int timeslot = 0;
        ArrayList<Double> energy = new ArrayList<Double>();
        NavigableSet<Integer> safeKeys = new TreeSet<Integer>(((BrokerModel)this.brokers.get(0)).getWholesaleCategory().getDynamicDataMap().keySet()).headSet(this.helper.getSafetyTimeslotIndex(), true);
        if (!safeKeys.isEmpty()) {
            timeslot = (Integer)safeKeys.last();
        }
        for (int i = 0; i < this.brokers.size(); ++i) {
            energy.add(((DynamicData)((BrokerModel)this.brokers.get(i)).getWholesaleCategory().getDynamicDataMap().get(timeslot)).getEnergyDelta());
        }
        return energy;
    }
}

