/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.json;

import org.powertac.common.Rate;
import org.primefaces.json.JSONArray;
import org.primefaces.json.JSONException;

public class RateInfoJSON {
    private JSONArray rateLineChartMinValue = new JSONArray();
    private JSONArray rateLineChartMaxValue = new JSONArray();

    public RateInfoJSON(Rate rate) {
        this.buildRateLineCharts(rate);
    }

    private void buildRateLineCharts(Rate rate) {
        int endHourIndex;
        int startDayIndex = rate.getWeeklyBegin() == -1 ? 1 : rate.getWeeklyBegin();
        int endDayIndex = rate.getWeeklyEnd() == -1 ? 7 : rate.getWeeklyEnd();
        int startHourIndex = rate.getDailyBegin() == -1 ? 0 : rate.getDailyBegin();
        int n = endHourIndex = rate.getDailyEnd() == -1 ? 23 : rate.getDailyEnd();
        if (startDayIndex > endDayIndex) {
            int i;
            for (i = 1; i <= endDayIndex; ++i) {
                this.createSingleSegment(i, rate, startHourIndex, endHourIndex);
            }
            for (i = startDayIndex; i <= 7; ++i) {
                this.createSingleSegment(i, rate, startHourIndex, endHourIndex);
            }
        } else {
            for (int i = startDayIndex; i <= endDayIndex; ++i) {
                this.createSingleSegment(i, rate, startHourIndex, endHourIndex);
            }
        }
    }

    private void createSingleSegment(int i, Rate rate, int startHourIndex, int endHourIndex) {
        try {
            JSONArray lineSegmentMinValue = new JSONArray();
            JSONArray startOfSegmentMinValue = new JSONArray();
            JSONArray endOfSegmentMinValue = new JSONArray();
            JSONArray lineSegmentMaxValue = new JSONArray();
            JSONArray startOfSegmentMaxValue = new JSONArray();
            JSONArray endOfSegmentMaxValue = new JSONArray();
            int currentDayStartIndex = (i - 1) * 24;
            startOfSegmentMinValue.put(currentDayStartIndex + startHourIndex).put(rate.getMinValue());
            endOfSegmentMinValue.put(currentDayStartIndex + endHourIndex).put(rate.getMinValue());
            lineSegmentMinValue.put((Object)startOfSegmentMinValue).put((Object)endOfSegmentMinValue);
            this.rateLineChartMinValue.put((Object)lineSegmentMinValue);
            startOfSegmentMaxValue.put(currentDayStartIndex + startHourIndex).put(rate.getMaxValue());
            endOfSegmentMaxValue.put(currentDayStartIndex + endHourIndex).put(rate.getMaxValue());
            lineSegmentMaxValue.put((Object)startOfSegmentMaxValue).put((Object)endOfSegmentMaxValue);
            this.rateLineChartMaxValue.put((Object)lineSegmentMaxValue);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public JSONArray getRateLineChartMaxValue() {
        return this.rateLineChartMaxValue;
    }

    public JSONArray getRateLineChartMinValue() {
        return this.rateLineChartMinValue;
    }
}

