/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.TariffSpecification;
import org.powertac.common.msg.TimeslotUpdate;
import org.powertac.common.repo.BrokerRepo;
import org.powertac.common.repo.CustomerRepo;
import org.powertac.common.repo.TariffRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MessageDispatcher {
    private static Logger log = LogManager.getLogger(MessageDispatcher.class);
    @Autowired
    private CustomerRepo customerRepo;
    @Autowired
    private BrokerRepo brokerRepo;
    @Autowired
    private TariffRepo tariffRepo;
    @Autowired
    private TimeslotRepo timeslotRepo;
    private HashMap<Class<?>, Set<Object>> registrations = new HashMap();
    private HashMap<Class<?>, Method> persisters;
    private Boolean tournamentMode = false;

    public void registerMessageHandler(Object handler, Class<?> messageType) {
        HashSet<Object> reg = (HashSet<Object>)this.registrations.get(messageType);
        if (reg == null) {
            reg = new HashSet<Object>();
            this.registrations.put(messageType, reg);
        }
        reg.add(handler);
    }

    public void routeMessage(Object message) {
        Class<?> clazz = message.getClass();
        if (this.tournamentMode.booleanValue() && this.persisters.get(clazz) != null) {
            this.persist(message);
        }
        log.debug("Route " + clazz.getName());
        Set targets = (Set)this.registrations.get(clazz);
        if (targets == null) {
            log.warn("no targets for message of type " + clazz.getName());
            return;
        }
        for (Object target : targets) {
            log.trace("dispatching to:" + target.getClass().getName());
            MessageDispatcher.dispatch(target, (String)"handleMessage", (Object[])new Object[]{message});
        }
    }

    public static Object dispatch(Object target, String methodName, Object ... args) {
        Logger log = LogManager.getLogger((String)target.getClass().getName());
        Object result = null;
        try {
            Class[] classes = new Class[args.length];
            for (int index = 0; index < args.length; ++index) {
                classes[index] = args[index].getClass();
            }
            Method method = target.getClass().getMethod(methodName, classes);
            log.debug("found method " + method);
            result = method.invoke(target, args);
        }
        catch (NoSuchMethodException nsm) {
            log.debug("Could not find exact match: " + nsm.toString());
        }
        catch (InvocationTargetException ite) {
            Throwable thr = ite.getTargetException();
            if (thr.getStackTrace().length > 3) {
                log.error("Cannot call " + methodName + "(" + args[0].getClass().getName() + "): " + thr.toString() + "\n  ..at " + thr.getStackTrace()[0] + "\n  ..at " + thr.getStackTrace()[1] + "\n  ..at " + thr.getStackTrace()[2] + "\n  ..at " + thr.getStackTrace()[3]);
            } else {
                log.error("Cannot call " + methodName + "(" + args[0].getClass().getName() + "): " + thr.toString());
            }
        }
        catch (Exception ex) {
            log.error("Exception calling message processor: " + ex.toString());
        }
        return result;
    }

    public void persistMessage(Competition competition) {
        Competition.setCurrent((Competition)competition);
        for (CustomerInfo customer : competition.getCustomers()) {
            this.customerRepo.add(customer);
        }
        for (String username : competition.getBrokers()) {
            this.brokerRepo.findOrCreateByUsername(username);
        }
    }

    public void persistMessage(TariffSpecification spec) {
        log.info("persisting spec " + spec.getId());
        this.tariffRepo.addSpecification(spec);
    }

    public void persistMessage(TimeslotUpdate tu) {
        this.timeslotRepo.findOrCreateBySerialNumber(tu.getLastEnabled());
    }

    private void persist(Object message) {
        Method method = (Method)this.persisters.get(message.getClass());
        try {
            method.invoke((Object)this, message);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void initialize() {
        Method[] methods;
        this.registrations = new HashMap();
        this.persisters = new HashMap();
        for (Method method : methods = this.getClass().getDeclaredMethods()) {
            if (!method.getName().equals("persistMessage")) continue;
            Class<?>[] params = method.getParameterTypes();
            this.persisters.put(params[0], method);
        }
    }

    public Boolean getTournamentMode() {
        return this.tournamentMode;
    }

    public void setTournamentMode(Boolean tournamentMode) {
        this.tournamentMode = tournamentMode;
    }
}

