/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain.genco;

import java.util.ArrayList;
import org.powertac.common.MarketPosition;
import org.powertac.common.MarketTransaction;
import org.powertac.common.Timeslot;

public class WholesaleDataGenco {
    private Timeslot timeslot;
    private ArrayList<MarketPosition> marketPositions;
    private ArrayList<MarketTransaction> marketTransactions;
    private double totalPrice;
    private double totalMWh;

    public WholesaleDataGenco(Timeslot timeslot) {
        this.timeslot = timeslot;
        this.marketPositions = new ArrayList();
        this.marketTransactions = new ArrayList();
    }

    public void addMarketPosition(MarketPosition position) {
        this.marketPositions.add(position);
    }

    public void addMarketTransaction(MarketTransaction transaction) {
        this.marketTransactions.add(transaction);
        this.totalPrice += transaction.getPrice();
        this.totalMWh += transaction.getMWh();
    }

    public Timeslot getTimeslot() {
        return this.timeslot;
    }

    public double getTotalMWh() {
        return this.totalMWh;
    }

    public double getTotalPrice() {
        return this.totalPrice;
    }

    public ArrayList<MarketPosition> getMarketPositions() {
        return (ArrayList)this.marketPositions.clone();
    }

    public ArrayList<MarketTransaction> getMarketTransactions() {
        return (ArrayList)this.marketTransactions.clone();
    }
}

