/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.CustomerInfo;
import org.powertac.common.enumerations.PowerType;
import org.powertac.visualizer.domain.customer.Customer;
import org.powertac.visualizer.interfaces.Recyclable;
import org.powertac.visualizer.interfaces.TimeslotCompleteActivation;
import org.springframework.stereotype.Service;

@Service
public class CustomerService
implements TimeslotCompleteActivation,
Recyclable {
    private static Logger log = LogManager.getLogger(CustomerService.class);
    private HashMap<CustomerInfo, Customer> customerMap;
    private ArrayList<Customer> customerList;

    public CustomerService() {
        this.recycle();
    }

    public void addCustomers(List<CustomerInfo> customerInfos) {
        HashMap<CustomerInfo, Customer> customers = new HashMap<CustomerInfo, Customer>();
        for (CustomerInfo customerInfo : customerInfos) {
            Customer customer = new Customer(customerInfo);
            customers.put(customerInfo, customer);
        }
        this.customerMap = customers;
        this.customerList = new ArrayList(this.customerMap.values());
        log.info("Customers added: List size:" + this.customerList.size() + " Map size:" + this.customerMap.size());
    }

    public Customer findCustomerByNameAndType(String customerName, PowerType type) {
        for (Map.Entry entry : this.customerMap.entrySet()) {
            CustomerInfo key = (CustomerInfo)entry.getKey();
            Customer value = (Customer)entry.getValue();
            if (!key.getName().equals(customerName) || key.getPowerType() != type) continue;
            return value;
        }
        return null;
    }

    public void recycle() {
        this.customerMap = new HashMap();
        this.customerList = new ArrayList();
    }

    public List<Customer> getCustomerList() {
        return (List)this.customerList.clone();
    }

    public void activate(int timeslotIndex, Instant postedTime) {
        for (Customer type : this.customerList) {
            type.update(timeslotIndex, postedTime);
        }
        log.debug("Customer service activation complete. Timeslotindex:" + timeslotIndex);
    }

    public Customer findCustomerByCustomerInfo(CustomerInfo customerInfo) {
        return (Customer)this.customerMap.get(customerInfo);
    }
}

