/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.interfaces.VisualizerMessageListener;
import org.powertac.common.interfaces.VisualizerProxy;
import org.powertac.visualizer.MessageDispatcher;
import org.powertac.visualizer.VisualizerApplicationContext;
import org.powertac.visualizer.beans.VisualizerBean;
import org.powertac.visualizer.interfaces.Initializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VisualizerServiceEmbedded
implements VisualizerMessageListener {
    private static Logger log = LogManager.getLogger((String)VisualizerServiceEmbedded.class.getName());
    @Autowired
    private VisualizerBean visualizerBean;
    private boolean alreadyRegistered = false;
    @Autowired
    private MessageDispatcher dispatcher;

    public void init(VisualizerProxy visualizerProxy) {
        this.visualizerBean.newRun();
        if (!this.alreadyRegistered) {
            visualizerProxy.registerVisualizerMessageListener((VisualizerMessageListener)this);
            this.alreadyRegistered = true;
        }
        List initializers = VisualizerApplicationContext.listBeansOfType(Initializable.class);
        for (Initializable init : initializers) {
            log.debug("initializing..." + init.getClass().getName());
            init.initialize();
        }
    }

    public void receiveMessage(Object msg) {
        this.visualizerBean.incrementMessageCounter();
        if (msg != null) {
            log.debug("Counter: " + this.visualizerBean.getMessageCount() + ", Got message: " + msg.getClass().getName());
            this.dispatcher.routeMessage(msg);
        } else {
            log.warn("Counter:" + this.visualizerBean.getMessageCount() + " Received message is NULL!");
        }
    }
}

