/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.Instant;
import org.powertac.common.ClearedTrade;
import org.powertac.visualizer.beans.VisualizerBean;
import org.powertac.visualizer.interfaces.Recyclable;
import org.powertac.visualizer.interfaces.TimeslotCompleteActivation;
import org.powertac.visualizer.push.StatisticsPusher;
import org.powertac.visualizer.services.BrokerService;
import org.powertac.visualizer.services.PushService;
import org.powertac.visualizer.services.handlers.VisualizerHelperService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WholesaleService
implements Serializable,
Recyclable,
TimeslotCompleteActivation {
    private static final long serialVersionUID = 1L;
    private ConcurrentHashMap<Long, ConcurrentHashMap<Long, ClearedTrade>> clearedTrades;
    @Autowired
    private BrokerService brokerService;
    @Autowired
    private VisualizerBean visualizerBean;
    @Autowired
    private PushService pushService;
    @Autowired
    private VisualizerHelperService visualizerHelperService;

    public WholesaleService() {
        this.recycle();
    }

    public void recycle() {
        this.clearedTrades = new ConcurrentHashMap(2000, 0.75f, 1);
    }

    public ConcurrentHashMap<Long, ConcurrentHashMap<Long, ClearedTrade>> getClearedTrades() {
        return this.clearedTrades;
    }

    public void activate(int timeslotIndex, Instant postedTime) {
        ArrayList<StatisticsPusher> statisticsPushers = new ArrayList<StatisticsPusher>();
        double totalRevenue = 0.0;
        double totalEnergy = 0.0;
        int numberOfTransactions = 0;
        ConcurrentHashMap clearedTradesInSafetyTimeslot = (ConcurrentHashMap)this.clearedTrades.get(this.visualizerHelperService.getMillisForIndex(this.visualizerHelperService.getSafetyWholesaleTimeslotIndex()));
        if (clearedTradesInSafetyTimeslot != null) {
            for (ClearedTrade clearedTrade : clearedTradesInSafetyTimeslot.values()) {
                totalRevenue += clearedTrade.getExecutionPrice();
                totalEnergy += clearedTrade.getExecutionMWh();
                ++numberOfTransactions;
            }
            statisticsPushers.add(new StatisticsPusher(this.visualizerHelperService.getMillisForIndex(this.visualizerHelperService.getSafetyWholesaleTimeslotIndex()), totalRevenue / (double)numberOfTransactions, totalEnergy));
            this.pushService.pushWholesaleAvg(statisticsPushers);
        }
    }
}

