/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services.competitioncontrol;

import java.util.ArrayList;
import org.powertac.common.interfaces.CompetitionControl;
import org.powertac.common.interfaces.CompetitionSetup;
import org.powertac.common.interfaces.VisualizerProxy;
import org.powertac.visualizer.services.VisualizerServiceEmbedded;
import org.powertac.visualizer.services.competitioncontrol.FakeBroker;
import org.powertac.visualizer.services.competitioncontrol.GameParametersBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WebCompetitionControlService {
    @Autowired
    private CompetitionSetup css;
    @Autowired
    private CompetitionControl competitionControl;
    @Autowired
    private VisualizerServiceEmbedded visualizerService;
    @Autowired
    private GameParametersBean gameParameters;
    @Autowired
    private VisualizerProxy visualizerProxy;
    private Boolean tournamentMode = false;
    private String message;

    public void runSim() {
        if (this.tournamentMode.booleanValue()) {
            this.message = "Unable to run sim in tournament configuration.";
            return;
        }
        if (this.competitionControl.isRunning()) {
            this.message = "Unable to run a sim game. The competition is already in progress.";
            return;
        }
        this.visualizerService.init(this.visualizerProxy);
        ArrayList<String> names = new ArrayList<String>();
        for (FakeBroker type : this.gameParameters.getBrokers()) {
            names.add(type.getName());
        }
        String result = this.css.simSession(this.gameParameters.getBootstrapData(), this.gameParameters.getServerConfig(), this.gameParameters.getJmsUrl(), null, this.gameParameters.getLogSuffix(), names, this.gameParameters.getSeedName(), this.gameParameters.getWeatherName(), null);
        this.message = result == null ? "Simulation started." : "ERROR: " + result;
    }

    public void runBoot() {
        if (this.tournamentMode.booleanValue()) {
            this.message = "Unable to run boot in tournament configuration.";
            return;
        }
        if (this.competitionControl.isRunning()) {
            this.message = "Unable to run a bootstrap game. The competition is already in progress.";
            return;
        }
        this.visualizerService.init(this.visualizerProxy);
        String result = this.css.bootSession(this.gameParameters.getBootstrapFilename(), this.gameParameters.getServerConfig(), null, this.gameParameters.getLogSuffix(), this.gameParameters.getSeedName(), this.gameParameters.getWeatherName());
        this.message = result == null ? "Bootstrap mode started." : "ERROR: " + result;
    }

    public void shutDown() {
        if (this.tournamentMode.booleanValue()) {
            this.message = "Not allowed in tournament configuration";
        } else if (this.competitionControl.isRunning()) {
            this.competitionControl.shutDown();
            this.message = "Shut down is complete.";
        } else {
            this.message = "There is no running game to shut down.";
        }
    }

    public String getMessage() {
        return this.message;
    }

    public Boolean getTournamentMode() {
        return this.tournamentMode;
    }

    public void setTournamentMode(Boolean tournamentMode) {
        this.tournamentMode = tournamentMode;
    }
}

