/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services.handlers;

import org.joda.time.Instant;
import org.powertac.common.Competition;
import org.powertac.visualizer.beans.VisualizerBean;
import org.powertac.visualizer.services.BrokerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VisualizerHelperService {
    @Autowired
    private VisualizerBean visualizerBean;
    @Autowired
    private BrokerService brokerService;

    public long getMillisForIndex(int index) {
        Competition comp = this.visualizerBean.getCompetition();
        if (comp != null) {
            return new Instant(comp.getSimulationBaseTime().getMillis() + (long)index * comp.getTimeslotDuration()).getMillis();
        }
        return -1L;
    }

    public int getTimeslotIndex(Instant time) {
        Competition comp = this.visualizerBean.getCompetition();
        if (comp != null) {
            long offset = time.getMillis() - comp.getSimulationBaseTime().getMillis();
            long duration = comp.getTimeslotDuration();
            return (int)(offset / duration);
        }
        return -1;
    }

    public int getSafetyWholesaleTimeslotIndex() {
        if (this.visualizerBean.getTimeslotComplete() != null) {
            int lastCompletedTimeslot = this.visualizerBean.getTimeslotComplete().getTimeslotIndex();
            return lastCompletedTimeslot - 1;
        }
        return -1;
    }

    public int getSafetyTimeslotIndex() {
        if (this.visualizerBean.getTimeslotComplete() != null) {
            int lastCompletedTimeslot = this.visualizerBean.getTimeslotComplete().getTimeslotIndex();
            return lastCompletedTimeslot;
        }
        return -1;
    }
}

