/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.user;

import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import org.powertac.common.WeatherReport;
import org.powertac.visualizer.services.WeatherInfoService;
import org.powertac.visualizer.services.handlers.VisualizerHelperService;
import org.springframework.beans.factory.annotation.Autowired;

public class WeatherBean
implements Serializable {
    private String temperatureData;
    private String windSpeedData;
    private String windDirectionData;
    private String cloudCoverData;

    @Autowired
    public WeatherBean(WeatherInfoService service, VisualizerHelperService helper) {
        Gson gson = new Gson();
        ArrayList<double[]> temps = new ArrayList<double[]>();
        ArrayList<double[]> windSpeeds = new ArrayList<double[]>();
        ArrayList<double[]> windDirections = new ArrayList<double[]>();
        ArrayList<double[]> clouds = new ArrayList<double[]>();
        TreeSet keys = new TreeSet(service.getReports().keySet());
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            WeatherReport report = (WeatherReport)service.getReports().get(key);
            long millis = helper.getMillisForIndex(key);
            double[] cloud = new double[]{millis, report.getCloudCover()};
            double[] windSpeed = new double[]{millis, report.getWindSpeed()};
            double[] windDirection = new double[]{millis, report.getWindDirection()};
            double[] temp = new double[]{millis, report.getTemperature()};
            clouds.add(cloud);
            windSpeeds.add(windSpeed);
            windDirections.add(windDirection);
            temps.add(temp);
        }
        if (keys.size() == 0) {
            double[] dummy = new double[]{helper.getMillisForIndex(0), 0.0};
            clouds.add(dummy);
            windSpeeds.add(dummy);
            windDirections.add(dummy);
            temps.add(dummy);
        }
        this.cloudCoverData = gson.toJson(clouds);
        this.windSpeedData = gson.toJson(windSpeeds);
        this.temperatureData = gson.toJson(temps);
        this.windDirectionData = gson.toJson(windDirections);
    }

    public String getCloudCoverData() {
        return this.cloudCoverData;
    }

    public String getTemperatureData() {
        return this.temperatureData;
    }

    public String getWindSpeedData() {
        return this.windSpeedData;
    }

    public String getWindDirectionData() {
        return this.windDirectionData;
    }
}

