/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services.handlers;

import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.BankTransaction;
import org.powertac.common.Competition;
import org.powertac.common.msg.DistributionReport;
import org.powertac.common.msg.SimEnd;
import org.powertac.common.msg.SimPause;
import org.powertac.common.msg.SimResume;
import org.powertac.common.msg.SimStart;
import org.powertac.common.msg.TariffExpire;
import org.powertac.common.msg.TariffRevoke;
import org.powertac.common.msg.TariffStatus;
import org.powertac.common.msg.TariffUpdate;
import org.powertac.common.msg.TimeslotComplete;
import org.powertac.common.msg.TimeslotUpdate;
import org.powertac.visualizer.MessageDispatcher;
import org.powertac.visualizer.VisualizerApplicationContext;
import org.powertac.visualizer.beans.AppearanceListBean;
import org.powertac.visualizer.beans.VisualizerBean;
import org.powertac.visualizer.interfaces.Initializable;
import org.powertac.visualizer.interfaces.TimeslotCompleteActivation;
import org.powertac.visualizer.push.GlobalPusher;
import org.powertac.visualizer.push.InfoPush;
import org.powertac.visualizer.services.PushService;
import org.powertac.visualizer.services.handlers.VisualizerHelperService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VisualizerMessageHandler
implements Initializable {
    private Logger log = LogManager.getLogger(VisualizerMessageHandler.class);
    @Autowired
    private VisualizerBean visualizerBean;
    @Autowired
    private VisualizerHelperService helper;
    @Autowired
    private AppearanceListBean appearanceListBean;
    @Autowired
    private MessageDispatcher router;
    @Autowired
    private PushService pushService;

    public void handleMessage(TimeslotUpdate timeslotUpdate) {
        if (this.visualizerBean.getTimeslotUpdate() != null) {
            this.visualizerBean.setOldTimeslotUpdate(this.visualizerBean.getTimeslotUpdate());
        }
        this.visualizerBean.setTimeslotUpdate(timeslotUpdate);
        this.visualizerBean.setCurrentMillis(timeslotUpdate.getPostedTime().getMillis());
        StringBuilder builder = new StringBuilder();
        builder.append("Enabled timeslots:");
        for (int i = timeslotUpdate.getFirstEnabled(); i < timeslotUpdate.getLastEnabled(); ++i) {
            builder.append(" ").append(i);
        }
        this.log.debug(builder + "\n");
        Competition comp = this.visualizerBean.getCompetition();
        int timeslotSerialNumber = timeslotUpdate.getFirstEnabled() - comp.getDeactivateTimeslotsAhead();
        this.visualizerBean.setCurrentTimeslotSerialNumber(timeslotSerialNumber);
    }

    public void handleMessage(TimeslotComplete complete) {
        this.visualizerBean.setTimeslotComplete(complete);
        List activators = VisualizerApplicationContext.listBeansOfType(TimeslotCompleteActivation.class);
        for (TimeslotCompleteActivation active : activators) {
            active.activate(complete.getTimeslotIndex(), this.visualizerBean.getTimeslotUpdate().getPostedTime());
        }
        this.pushService.pushGlobal(new GlobalPusher(this.visualizerBean.getWeatherPusher(), this.visualizerBean.getNominationPusher()));
    }

    public void handleMessage(SimStart simStart) {
    }

    public void handleMessage(SimEnd simEnd) {
        this.visualizerBean.setRunning(false);
        this.visualizerBean.setFinished(true);
        this.pushService.pushInfoMessage(new InfoPush("finish"));
    }

    public void handleMessage(SimPause simPause) {
    }

    public void handleMessage(BankTransaction bankTransaction) {
    }

    public void handleMessage(SimResume simResume) {
    }

    public void handleMessage(DistributionReport report) {
        this.log.debug("DIST REPORT: PROD " + report.getTotalProduction() + "CONS " + report.getTotalConsumption());
    }

    public void handleMessage(TariffExpire msg) {
    }

    public void handleMessage(TariffRevoke msg) {
    }

    public void handleMessage(TariffStatus msg) {
    }

    public void handleMessage(TariffUpdate msg) {
    }

    public void initialize() {
        for (Class clazz : Arrays.asList(DistributionReport.class, SimResume.class, SimEnd.class, BankTransaction.class, SimPause.class, SimStart.class, TimeslotComplete.class, TimeslotUpdate.class, TariffExpire.class, TariffRevoke.class, TariffStatus.class, TariffUpdate.class)) {
            this.router.registerMessageHandler((Object)this, clazz);
        }
    }
}

