/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.ClearedTrade;
import org.powertac.common.MarketPosition;
import org.powertac.common.MarketTransaction;
import org.powertac.common.Order;
import org.powertac.common.Orderbook;
import org.powertac.common.msg.TimeslotUpdate;
import org.powertac.visualizer.MessageDispatcher;
import org.powertac.visualizer.beans.VisualizerBean;
import org.powertac.visualizer.domain.broker.BrokerModel;
import org.powertac.visualizer.interfaces.Initializable;
import org.powertac.visualizer.services.BrokerService;
import org.powertac.visualizer.services.GradingService;
import org.powertac.visualizer.services.WholesaleService;
import org.powertac.visualizer.services.handlers.VisualizerHelperService;
import org.powertac.visualizer.statistical.WholesaleCategory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WholesaleMessageHandler
implements Initializable {
    private Logger log = LogManager.getLogger(WholesaleMessageHandler.class);
    @Autowired
    private VisualizerBean visualizerBean;
    @Autowired
    private MessageDispatcher router;
    @Autowired
    private WholesaleService wholesaleService;
    @Autowired
    private BrokerService brokerService;
    @Autowired
    private VisualizerHelperService helper;
    @Autowired
    private GradingService gradingBean;

    public void initialize() {
        for (Class clazz : Arrays.asList(Order.class, Orderbook.class, ClearedTrade.class, MarketPosition.class, MarketTransaction.class)) {
            this.router.registerMessageHandler((Object)this, clazz);
        }
    }

    public void handleMessage(MarketTransaction msg) {
        BrokerModel broker = (BrokerModel)this.brokerService.getBrokersMap().get(msg.getBroker().getUsername());
        if (broker != null) {
            WholesaleCategory wc = broker.getWholesaleCategory();
            int tsIndex = msg.getTimeslot().getSerialNumber();
            wc.update(tsIndex, msg.getMWh(), msg.getPrice() * Math.abs(msg.getMWh()));
            wc.getMarketTxs().putIfAbsent(msg.getTimeslot().getSerialNumber(), new ArrayList(24));
            ((List)wc.getMarketTxs().get(msg.getTimeslot().getSerialNumber())).add(msg);
            if (msg.getMWh() > 0.0) {
                wc.addEnergyBought(msg.getMWh());
                wc.addCostFromBuying(-1.0 * Math.abs(msg.getPrice() * msg.getMWh()));
                this.gradingBean.addBoughtEnergyWholesaleMarket(msg.getMWh());
                this.gradingBean.addMoneyFromBuyingWholesaleMarket(-1.0 * Math.abs(msg.getPrice() * msg.getMWh()));
            } else {
                wc.addEnergySold(msg.getMWh());
                wc.addRevenueFromSelling(Math.abs(msg.getPrice() * msg.getMWh()));
                this.gradingBean.addSoldEnergyWholesaleMarket(msg.getMWh());
                this.gradingBean.addMoneyFromSellingWholesaleMarket(Math.abs(msg.getPrice() * msg.getMWh()));
            }
        }
    }

    public void handleMessage(MarketPosition marketPosition) {
    }

    public void handleMessage(Order order) {
    }

    public void handleMessage(Orderbook orderbook) {
    }

    public void handleMessage(ClearedTrade ct) {
        ConcurrentHashMap map = this.wholesaleService.getClearedTrades();
        map.putIfAbsent(ct.getTimeslot().getStartInstant().getMillis(), new ConcurrentHashMap(24, 0.75f, 1));
        TimeslotUpdate old = this.visualizerBean.getOldTimeslotUpdate();
        if (old != null) {
            ((ConcurrentHashMap)map.get(ct.getTimeslot().getStartInstant().getMillis())).put(old.getPostedTime().getMillis(), ct);
        } else {
            this.log.warn("The old timeslot update does not exist.");
        }
    }
}

