/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.user;

import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.powertac.visualizer.display.BrokerSeriesTemplate;
import org.powertac.visualizer.domain.broker.BrokerModel;
import org.powertac.visualizer.services.BrokerService;
import org.powertac.visualizer.services.handlers.VisualizerHelperService;
import org.powertac.visualizer.statistical.DynamicData;
import org.springframework.beans.factory.annotation.Autowired;

public class BalancingMarketBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String balancingDynData;
    private String balancingDynDataOneTimeslot;

    @Autowired
    public BalancingMarketBean(BrokerService brokerService, VisualizerHelperService helper) {
        Gson gson = new Gson();
        this.createBrokerBalancingTransactions(gson, brokerService, helper);
    }

    private void createBrokerBalancingTransactions(Gson gson, BrokerService brokerService, VisualizerHelperService helper) {
        ArrayList brokers = brokerService.getBrokers();
        ArrayList<BrokerSeriesTemplate> balancingTxData = new ArrayList<BrokerSeriesTemplate>();
        ArrayList<BrokerSeriesTemplate> balancingTxDataOneTimeslot = new ArrayList<BrokerSeriesTemplate>();
        for (BrokerModel brokerModel : brokers) {
            ArrayList<Object[]> profitData = new ArrayList<Object[]>();
            ArrayList<Object[]> netKwhData = new ArrayList<Object[]>();
            ArrayList<Object[]> profitDataOneTimeslot = new ArrayList<Object[]>();
            ArrayList<Object[]> kwhDataOneTimeslot = new ArrayList<Object[]>();
            ConcurrentHashMap dynDataMap = brokerModel.getBalancingCategory().getDynamicDataMap();
            TreeSet dynDataSet = new TreeSet(dynDataMap.keySet());
            Iterator iterator2 = dynDataSet.iterator();
            while (iterator2.hasNext()) {
                int key = (Integer)iterator2.next();
                DynamicData dynData = (DynamicData)dynDataMap.get(key);
                Object[] profit = new Object[]{helper.getMillisForIndex(key), dynData.getProfit()};
                Object[] netMwh = new Object[]{helper.getMillisForIndex(key), dynData.getEnergy()};
                profitData.add(profit);
                netKwhData.add(netMwh);
                Object[] profitOneTimeslot = new Object[]{helper.getMillisForIndex(key), dynData.getProfitDelta()};
                Object[] kWhOneTimeslot = new Object[]{helper.getMillisForIndex(key), dynData.getEnergyDelta()};
                profitDataOneTimeslot.add(profitOneTimeslot);
                kwhDataOneTimeslot.add(kWhOneTimeslot);
            }
            if (dynDataSet.size() == 0) {
                double[] dummy = new double[]{helper.getMillisForIndex(0), 0.0};
                profitData.add(dummy);
                profitDataOneTimeslot.add(dummy);
                kwhDataOneTimeslot.add(dummy);
                netKwhData.add(dummy);
            }
            balancingTxData.add(new BrokerSeriesTemplate(brokerModel.getName(), brokerModel.getAppearance().getColorCode(), 0, profitData, true));
            balancingTxData.add(new BrokerSeriesTemplate(brokerModel.getName(), brokerModel.getAppearance().getColorCode(), 1, netKwhData, false));
            balancingTxDataOneTimeslot.add(new BrokerSeriesTemplate(brokerModel.getName(), brokerModel.getAppearance().getColorCode(), 0, profitDataOneTimeslot, true));
            balancingTxDataOneTimeslot.add(new BrokerSeriesTemplate(brokerModel.getName(), brokerModel.getAppearance().getColorCode(), 1, kwhDataOneTimeslot, false));
        }
        this.balancingDynData = gson.toJson(balancingTxData);
        this.balancingDynDataOneTimeslot = gson.toJson(balancingTxDataOneTimeslot);
    }

    public String getBalancingDynData() {
        return this.balancingDynData;
    }

    public String getBalancingDynDataOneTimeslot() {
        return this.balancingDynDataOneTimeslot;
    }
}

