/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain.broker;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.CustomerInfo;
import org.powertac.common.TariffTransaction;
import org.powertac.visualizer.Helper;

public class CustomerModel {
    Logger log = LogManager.getLogger(CustomerModel.class);
    private int customerCount;
    private double cashInflow;
    private double cashOutflow;
    private double energyConsumption;
    private double energyProduction;
    private CustomerInfo customerInfo;
    private List<TariffTransaction> tariffTransactions;

    public CustomerModel(CustomerInfo customerInfo) {
        this.customerInfo = customerInfo;
        this.initialize();
    }

    public CustomerModel() {
        this.initialize();
    }

    private void initialize() {
        this.tariffTransactions = new ArrayList();
    }

    public void addTariffTransaction(TariffTransaction tariffTransaction) {
        this.log.info("\n CustomerModel: my tariffTrans: +\n" + tariffTransaction.toString());
        this.tariffTransactions.add(tariffTransaction);
        this.update(tariffTransaction);
    }

    public boolean equals(Object obj) {
        CustomerModel customerModel;
        return obj instanceof CustomerModel && (customerModel = (CustomerModel)obj).getCustomerInfo().getId() == this.getCustomerInfo().getId();
    }

    public int hashCode() {
        return (int)this.getCustomerInfo().getId();
    }

    private void update(TariffTransaction tariffTransaction) {
        this.updateCash(tariffTransaction.getCharge());
        this.updateEnergy(tariffTransaction.getKWh());
        this.customerCount += Helper.getCustomerCount((TariffTransaction)tariffTransaction);
    }

    private void updateEnergy(double kWh) {
        if (kWh > 0.0) {
            this.energyProduction += kWh;
        } else {
            this.energyConsumption += kWh;
        }
        this.log.debug("\n energy consumption:" + this.energyConsumption + " energy production:" + this.energyProduction);
    }

    private void updateCash(double charge) {
        if ((charge *= -1.0) > 0.0) {
            this.cashInflow += charge;
        } else {
            this.cashOutflow += charge;
        }
        this.log.debug("\n CashInflow:" + this.cashInflow + " CashOutflow:" + this.cashOutflow);
    }

    public int getCustomerCount() {
        return this.customerCount;
    }

    public CustomerInfo getCustomerInfo() {
        return this.customerInfo;
    }

    public List<TariffTransaction> getTariffTransactions() {
        return this.tariffTransactions;
    }

    public double getCashInflow() {
        return this.cashInflow;
    }

    public double getCashOutflow() {
        return this.cashOutflow;
    }

    public synchronized double getTotalCash() {
        return this.cashInflow + this.cashOutflow;
    }

    public double getEnergyConsumption() {
        return this.energyConsumption;
    }

    public double getEnergyProduction() {
        return this.energyProduction;
    }

    public synchronized double getTotalEnergy() {
        return this.energyProduction + this.energyConsumption;
    }
}

