/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services;

import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.Competition;
import org.powertac.common.XMLMessageConverter;
import org.powertac.common.msg.BrokerAccept;
import org.powertac.common.msg.BrokerAuthentication;
import org.powertac.common.msg.VisualizerStatusRequest;
import org.powertac.common.repo.DomainRepo;
import org.powertac.visualizer.MessageDispatcher;
import org.powertac.visualizer.VisualizerApplicationContext;
import org.powertac.visualizer.beans.VisualizerBean;
import org.powertac.visualizer.interfaces.Initializable;
import org.powertac.visualizer.services.VisualizerServiceTournament;
import org.powertac.visualizer.services.VisualizerState;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Service
public class VisualizerServiceTournament
implements MessageListener,
InitializingBean {
    private static Logger log = LogManager.getLogger((String)VisualizerServiceTournament.class.getName());
    @Resource(name="jmsFactory")
    private ConnectionFactory connectionFactory;
    @Autowired
    private ThreadPoolTaskExecutor taskExecutor;
    @Autowired
    XMLMessageConverter converter;
    @Autowired
    JmsTemplate template;
    @Autowired
    private VisualizerBean visualizerBean;
    private String tournamentUrl = "";
    private String visualizerLoginContext = "";
    private String machineName = "";
    private String serverUrl = "tcp://localhost:61616";
    private String serverQueue = "serverInput";
    private String queueName = "remote-visualizer";
    private LocalVisualizerProxy proxy;
    private boolean initialized = false;
    private boolean running = false;
    private long tickPeriod = 30000L;
    private long maxMsgInterval = 120000L;
    private long maxGameReadyInterval = 300000L;
    private long gameReadyAt = 0L;
    private long lastMsgTime = 0L;
    private boolean runningStates = true;
    private VisualizerState initial;
    private VisualizerState loginWait;
    private VisualizerState gameWait;
    private VisualizerState gameReady;
    private VisualizerState loggedIn;
    private VisualizerState currentState;
    private BlockingQueue<VisualizerState.Event> eventQueue = new LinkedBlockingQueue();
    private BlockingQueue<Object> messageQueue = new LinkedBlockingQueue();
    private Timer tickTimer = null;
    private TimerTask stateTask = null;
    private Thread messageFeeder = null;
    private Thread stateRunner = null;
    @Autowired
    private MessageDispatcher dispatcher;
    private Runnable runStates = new /* Unavailable Anonymous Inner Class!! */;
    private Runnable messagePump = new /* Unavailable Anonymous Inner Class!! */;

    public void init() {
        this.messageFeeder = new Thread(this.messagePump);
        this.messageFeeder.setDaemon(true);
        this.messageFeeder.start();
        this.tickTimer = new Timer(true);
        this.stateTask = new /* Unavailable Anonymous Inner Class!! */;
        this.tickTimer.schedule(this.stateTask, 10L, this.tickPeriod);
        this.stateRunner = new Thread(this.runStates);
        this.stateRunner.setDaemon(true);
        this.stateRunner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    private void cleanUp() throws Exception {
        Thread[] threadArray;
        System.out.print("\nCleaning up VisualizerServiceTournament (8) : ");
        if (this.proxy != null) {
            this.proxy.shutDown();
        }
        System.out.print("1 ");
        while (this.tickTimer == null) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        System.out.print("2 ");
        this.tickTimer.cancel();
        this.tickTimer.purge();
        this.tickTimer = null;
        System.out.print("3 ");
        if (this.stateTask != null) {
            this.stateTask.cancel();
        }
        System.out.print("4 ");
        try {
            this.messageFeeder.interrupt();
            this.messageFeeder.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.print("5 ");
        this.eventQueue.clear();
        this.putEvent(VisualizerState.Event.quit);
        while (this.runningStates) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.currentState != this.loginWait || this.stateRunner == null || this.stateRunner.getState() != Thread.State.TIMED_WAITING) continue;
            this.stateRunner.interrupt();
        }
        System.out.print("6 ");
        try {
            this.stateRunner.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.print("7 ");
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        for (Thread t : threadArray = threadSet.toArray(new Thread[threadSet.size()])) {
            if (!t.getName().contains("Timer-") && !t.getName().contains("ActiveMQ")) continue;
            Thread thread = t;
            synchronized (thread) {
                t.stop();
            }
        }
        System.out.println("8\n");
    }

    private void putEvent(VisualizerState.Event event) {
        try {
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private VisualizerState.Event getEvent() {
        try {
            return (VisualizerState.Event)this.eventQueue.take();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return VisualizerState.Event.tick;
        }
    }

    private void setCurrentState(VisualizerState newState) {
        this.currentState = newState;
        newState.entry();
    }

    private void tournamentLogin() {
        if (this.tournamentUrl.isEmpty()) {
            this.putEvent(VisualizerState.Event.noTm);
            return;
        }
        OperatingSystemMXBean mxBean = ManagementFactory.getOperatingSystemMXBean();
        double load = mxBean.getSystemLoadAverage();
        String urlString = this.tournamentUrl + this.visualizerLoginContext + "?machineName=" + this.machineName + "&machineLoad=" + load;
        log.info("tourney url=" + urlString);
        try {
            URL url = new URL(urlString);
            URLConnection conn = url.openConnection();
            InputStream input = conn.getInputStream();
            log.info("Parsing message..");
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(input);
            doc.getDocumentElement().normalize();
            Node retryNode = doc.getElementsByTagName("retry").item(0);
            Node loginNode = doc.getElementsByTagName("login").item(0);
            if (retryNode != null) {
                String checkRetry = retryNode.getFirstChild().getNodeValue();
                log.info("Retry in " + checkRetry + " seconds");
                try {
                    Thread.sleep(Integer.parseInt(checkRetry) * 1000);
                }
                catch (InterruptedException interruptedException) {}
            } else if (loginNode != null) {
                log.info("Login response received! ");
                this.queueName = doc.getElementsByTagName("queueName").item(0).getFirstChild().getNodeValue();
                this.serverQueue = doc.getElementsByTagName("serverQueue").item(0).getFirstChild().getNodeValue();
                log.info(String.format("Login message received: queueName=%s, serverQueue=%s", this.queueName, this.serverQueue));
                this.putEvent(VisualizerState.Event.accept);
            } else {
                log.info("Invalid response from TS");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void gameLogin() {
        if (null == this.proxy) {
            this.proxy = new LocalVisualizerProxy(this);
            this.proxy.init(this);
        }
        this.pingServer();
    }

    private void pingServer() {
        log.info("Ping sim server");
        this.proxy.sendMessage((Object)new VisualizerStatusRequest());
    }

    private boolean isInactive() {
        long now = new Date().getTime();
        long silence = now - this.lastMsgTime;
        if (silence > this.maxMsgInterval) {
            log.info("Inactivity declared");
            return true;
        }
        return false;
    }

    public void initOnce() {
        this.initialized = true;
        log.info("initOnce()");
        this.visualizerBean.newRun();
        this.dispatcher.initialize();
        List initializers = VisualizerApplicationContext.listBeansOfType(Initializable.class);
        for (Initializable init : initializers) {
            log.debug("initializing..." + init.getClass().getName());
            init.initialize();
        }
        List repos = VisualizerApplicationContext.listBeansOfType(DomainRepo.class);
        for (DomainRepo repo : repos) {
            log.debug("recycling..." + repos.getClass().getName());
            repo.recycle();
        }
    }

    public void shutDown() {
        this.initialized = false;
        log.info("shut down proxy");
        this.proxy.shutDown();
        this.proxy = null;
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void putMessage(Object message) {
        try {
            this.messageQueue.put(message);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private Object getMessage() {
        try {
            return this.messageQueue.take();
        }
        catch (InterruptedException e) {
            return e;
        }
    }

    public void receiveMessage(Object msg) {
        if (msg instanceof Competition) {
            this.initOnce();
        } else if (!this.initialized) {
            log.info("ERROR: msg of type " + msg.getClass().getName() + ", but not initialized. Ignoring.");
            return;
        }
        this.visualizerBean.incrementMessageCounter();
        if (msg != null) {
            this.dispatcher.routeMessage(msg);
        } else {
            log.info("Counter:" + this.visualizerBean.getMessageCount() + " Received message is NULL!");
        }
        if (!this.running && this.visualizerBean.isRunning()) {
            this.running = true;
        }
        if (this.running && this.visualizerBean.isFinished()) {
            log.info("Game finished");
            this.putEvent(VisualizerState.Event.simEnd);
        }
    }

    public void onMessage(Message message) {
        this.lastMsgTime = new Date().getTime();
        if (message instanceof TextMessage) {
            try {
                this.onMessage(((TextMessage)message).getText());
            }
            catch (JMSException e) {
                log.info("ERROR: viz failed to extract text from TextMessage: " + e.toString());
            }
        }
    }

    private void onMessage(String xml) {
        log.debug("onMessage(String) - received message:\n" + xml);
        Object message = this.converter.fromXML(xml);
        log.debug("onMessage(String) - received message of type " + message.getClass().getSimpleName());
        if (message instanceof VisualizerStatusRequest) {
            log.info("Received vsr");
            this.putEvent(VisualizerState.Event.vsr);
        } else if (!(message instanceof BrokerAccept) && !(message instanceof BrokerAuthentication)) {
            this.putMessage(message);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Timer initTimer = new Timer(true);
        initTimer.schedule((TimerTask)new /* Unavailable Anonymous Inner Class!! */, 20000L);
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String newName) {
        this.queueName = newName;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String newUrl) {
        this.serverUrl = newUrl;
    }

    public String getTournamentUrl() {
        return this.tournamentUrl;
    }

    public void setTournamentUrl(String newUrl) {
        this.tournamentUrl = newUrl;
    }

    public String getVisualizerLoginContext() {
        return this.visualizerLoginContext;
    }

    public void setVisualizerLoginContext(String newContext) {
        this.visualizerLoginContext = newContext;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public void setMachineName(String name) {
        this.machineName = name;
    }

    static /* synthetic */ VisualizerBean access$000(VisualizerServiceTournament x0) {
        return x0.visualizerBean;
    }

    static /* synthetic */ BlockingQueue access$100(VisualizerServiceTournament x0) {
        return x0.messageQueue;
    }

    static /* synthetic */ Logger access$200() {
        return log;
    }

    static /* synthetic */ VisualizerState access$300(VisualizerServiceTournament x0) {
        return x0.currentState;
    }

    static /* synthetic */ VisualizerState access$400(VisualizerServiceTournament x0) {
        return x0.loginWait;
    }

    static /* synthetic */ BlockingQueue access$500(VisualizerServiceTournament x0) {
        return x0.eventQueue;
    }

    static /* synthetic */ void access$600(VisualizerServiceTournament x0, VisualizerState.Event x1) {
        x0.putEvent(x1);
    }

    static /* synthetic */ boolean access$702(VisualizerServiceTournament x0, boolean x1) {
        x0.runningStates = x1;
        return x0.runningStates;
    }

    static /* synthetic */ VisualizerState access$802(VisualizerServiceTournament x0, VisualizerState x1) {
        x0.initial = x1;
        return x0.initial;
    }

    static /* synthetic */ LocalVisualizerProxy access$900(VisualizerServiceTournament x0) {
        return x0.proxy;
    }

    static /* synthetic */ void access$1000(VisualizerServiceTournament x0, VisualizerState x1) {
        x0.setCurrentState(x1);
    }

    static /* synthetic */ VisualizerState access$402(VisualizerServiceTournament x0, VisualizerState x1) {
        x0.loginWait = x1;
        return x0.loginWait;
    }

    static /* synthetic */ void access$1100(VisualizerServiceTournament x0) {
        x0.tournamentLogin();
    }

    static /* synthetic */ VisualizerState access$1200(VisualizerServiceTournament x0) {
        return x0.gameWait;
    }

    static /* synthetic */ VisualizerState access$1300(VisualizerServiceTournament x0) {
        return x0.gameReady;
    }

    static /* synthetic */ VisualizerState access$1202(VisualizerServiceTournament x0, VisualizerState x1) {
        x0.gameWait = x1;
        return x0.gameWait;
    }

    static /* synthetic */ void access$1400(VisualizerServiceTournament x0) {
        x0.gameLogin();
    }

    static /* synthetic */ VisualizerState access$1500(VisualizerServiceTournament x0) {
        return x0.loggedIn;
    }

    static /* synthetic */ void access$1600(VisualizerServiceTournament x0) {
        x0.pingServer();
    }

    static /* synthetic */ VisualizerState access$1302(VisualizerServiceTournament x0, VisualizerState x1) {
        x0.gameReady = x1;
        return x0.gameReady;
    }

    static /* synthetic */ long access$1702(VisualizerServiceTournament x0, long x1) {
        x0.gameReadyAt = x1;
        return x0.gameReadyAt;
    }

    static /* synthetic */ long access$1700(VisualizerServiceTournament x0) {
        return x0.gameReadyAt;
    }

    static /* synthetic */ long access$1800(VisualizerServiceTournament x0) {
        return x0.maxGameReadyInterval;
    }

    static /* synthetic */ VisualizerState access$800(VisualizerServiceTournament x0) {
        return x0.initial;
    }

    static /* synthetic */ VisualizerState access$1502(VisualizerServiceTournament x0, VisualizerState x1) {
        x0.loggedIn = x1;
        return x0.loggedIn;
    }

    static /* synthetic */ boolean access$1900(VisualizerServiceTournament x0) {
        return x0.isInactive();
    }

    static /* synthetic */ boolean access$700(VisualizerServiceTournament x0) {
        return x0.runningStates;
    }

    static /* synthetic */ VisualizerState.Event access$2000(VisualizerServiceTournament x0) {
        return x0.getEvent();
    }

    static /* synthetic */ Object access$2100(VisualizerServiceTournament x0) {
        return x0.getMessage();
    }

    static /* synthetic */ Timer access$2200(VisualizerServiceTournament x0) {
        return x0.tickTimer;
    }

    static /* synthetic */ ConnectionFactory access$2300(VisualizerServiceTournament x0) {
        return x0.connectionFactory;
    }

    static /* synthetic */ ThreadPoolTaskExecutor access$2400(VisualizerServiceTournament x0) {
        return x0.taskExecutor;
    }

    static /* synthetic */ String access$2500(VisualizerServiceTournament x0) {
        return x0.serverQueue;
    }
}

