/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.beans;

import java.io.Serializable;
import java.util.List;
import javax.faces.bean.ManagedBean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.Competition;
import org.powertac.common.msg.TimeslotComplete;
import org.powertac.common.msg.TimeslotUpdate;
import org.powertac.visualizer.VisualizerApplicationContext;
import org.powertac.visualizer.beans.AppearanceListBean;
import org.powertac.visualizer.interfaces.Recyclable;
import org.powertac.visualizer.push.NominationCategoryPusher;
import org.powertac.visualizer.push.NominationPusher;
import org.powertac.visualizer.push.WeatherPusher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ManagedBean
@Service
public class VisualizerBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger log = LogManager.getLogger(VisualizerBean.class);
    private int messageCounter;
    private int visualizerRunCount;
    private NominationPusher nominationPusher;
    private WeatherPusher weatherPusher;
    private Competition competition;
    private TimeslotUpdate oldTimeslotUpdate;
    private TimeslotUpdate timeslotUpdate;
    private String simulationStatus;
    private int currentTimeslotSerialNumber;
    private boolean finished;
    private boolean running;
    private long currentMillis;
    private TimeslotComplete timeslotComplete;
    @Autowired
    private AppearanceListBean appearanceList;
    private Boolean tournamentMode = false;

    public VisualizerBean() {
        this.init();
    }

    public void incrementMessageCounter() {
        ++this.messageCounter;
    }

    public int getMessageCount() {
        return this.messageCounter;
    }

    public void newRun() {
        this.init();
        this.appearanceList.resetAvailableList();
        List recyclables = VisualizerApplicationContext.listBeansOfType(Recyclable.class);
        for (Recyclable rec : recyclables) {
            this.log.info("recycling..." + rec.getClass().getName());
            rec.recycle();
        }
    }

    public void init() {
        this.messageCounter = 0;
        ++this.visualizerRunCount;
        this.competition = null;
        this.oldTimeslotUpdate = null;
        this.timeslotUpdate = null;
        this.simulationStatus = null;
        this.currentTimeslotSerialNumber = -1;
        this.finished = false;
        this.running = false;
        this.currentMillis = 0L;
        NominationCategoryPusher dummyNc = new NominationCategoryPusher("", 0L);
        this.nominationPusher = new NominationPusher(dummyNc, dummyNc, dummyNc);
        this.weatherPusher = new WeatherPusher(0L, 0.0, 0.0, 0.0, 0.0, 0);
    }

    public NominationPusher getNominationPusher() {
        return this.nominationPusher;
    }

    public void setNominationPusher(NominationPusher nominationPusher) {
        this.nominationPusher = nominationPusher;
    }

    public int getVisualizerRunCount() {
        return this.visualizerRunCount;
    }

    public Competition getCompetition() {
        return this.competition;
    }

    public void setCompetition(Competition competition) {
        this.competition = competition;
    }

    public TimeslotUpdate getTimeslotUpdate() {
        return this.timeslotUpdate;
    }

    public void setTimeslotUpdate(TimeslotUpdate timeslotUpdate) {
        this.timeslotUpdate = timeslotUpdate;
    }

    public String getSimulationStatus() {
        return this.simulationStatus;
    }

    public void setSimulationStatus(String simulationStatus) {
        this.simulationStatus = simulationStatus;
    }

    public int getCurrentTimeslotSerialNumber() {
        return this.currentTimeslotSerialNumber;
    }

    public void setCurrentTimeslotSerialNumber(int currentTimeslotSerialNumber) {
        this.currentTimeslotSerialNumber = currentTimeslotSerialNumber;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public long getCurrentMillis() {
        return this.currentMillis;
    }

    public WeatherPusher getWeatherPusher() {
        return this.weatherPusher;
    }

    public void setWeatherPusher(WeatherPusher weatherPusher) {
        this.weatherPusher = weatherPusher;
    }

    public void setCurrentMillis(long currentMillis) {
        this.currentMillis = currentMillis;
    }

    public TimeslotUpdate getOldTimeslotUpdate() {
        return this.oldTimeslotUpdate;
    }

    public void setOldTimeslotUpdate(TimeslotUpdate oldTimeslotUpdate) {
        this.oldTimeslotUpdate = oldTimeslotUpdate;
    }

    public Boolean getTournamentMode() {
        return this.tournamentMode;
    }

    public void setTournamentMode(Boolean tournamentMode) {
        this.tournamentMode = tournamentMode;
    }

    public TimeslotComplete getTimeslotComplete() {
        return this.timeslotComplete;
    }

    public void setTimeslotComplete(TimeslotComplete timeslotComplete) {
        this.timeslotComplete = timeslotComplete;
    }
}

