/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain.customer;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.TariffTransaction;
import org.powertac.common.msg.CustomerBootstrapData;
import org.powertac.visualizer.domain.broker.CustomerModel;
import org.powertac.visualizer.interfaces.TimeslotModelUpdate;

public class Customer
implements TimeslotModelUpdate {
    private Logger log = LogManager.getLogger(Customer.class);
    private CustomerModel customerModel;
    private CustomerInfo customerInfo;
    private CustomerBootstrapData bootstrapData;
    private double currentKWhProduced;
    private double currentKWhConsumed;
    private double currentInflowCharge;
    private double currentOutflowCharge;

    public Customer(CustomerInfo customerInfo) {
        this.customerModel = new CustomerModel(customerInfo);
        this.customerInfo = customerInfo;
    }

    public CustomerModel getCustomerModel() {
        return this.customerModel;
    }

    public void addCustomerBootstrapData(CustomerBootstrapData data, Competition competition) {
        this.bootstrapData = data;
    }

    public void addTariffTransaction(TariffTransaction tx) {
        double kWh = tx.getKWh();
        double charge = -1.0 * tx.getCharge();
        if (kWh < 0.0) {
            this.currentKWhConsumed += kWh;
        } else {
            this.currentKWhProduced += kWh;
        }
        if (charge > 0.0) {
            this.currentInflowCharge += charge;
        } else {
            this.currentOutflowCharge += charge;
        }
        this.customerModel.addTariffTransaction(tx);
    }

    public void update(int timeslotIndex, Instant postedTime) {
        this.currentInflowCharge = 0.0;
        this.currentOutflowCharge = 0.0;
        this.currentKWhConsumed = 0.0;
        this.currentKWhProduced = 0.0;
    }

    public CustomerInfo getCustomerInfo() {
        return this.customerInfo;
    }

    public String toString() {
        return this.getCustomerInfo().getName();
    }
}

