/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.BalancingTransaction;
import org.powertac.common.CashPosition;
import org.powertac.common.Competition;
import org.powertac.common.DistributionTransaction;
import org.powertac.common.TariffSpecification;
import org.powertac.common.TariffTransaction;
import org.powertac.visualizer.Helper;
import org.powertac.visualizer.MessageDispatcher;
import org.powertac.visualizer.beans.AppearanceListBean;
import org.powertac.visualizer.beans.VisualizerBean;
import org.powertac.visualizer.domain.broker.BrokerModel;
import org.powertac.visualizer.domain.broker.TariffData;
import org.powertac.visualizer.domain.broker.TariffDynamicData;
import org.powertac.visualizer.interfaces.Initializable;
import org.powertac.visualizer.push.InfoPush;
import org.powertac.visualizer.services.BrokerService;
import org.powertac.visualizer.services.GradingService;
import org.powertac.visualizer.services.PushService;
import org.powertac.visualizer.statistical.BalancingCategory;
import org.powertac.visualizer.statistical.DistributionCategory;
import org.powertac.visualizer.statistical.FinanceCategory;
import org.powertac.visualizer.statistical.FinanceDynamicData;
import org.powertac.visualizer.statistical.TariffCategory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BrokerMessageHandler
implements Initializable {
    private Logger log = LogManager.getLogger(BrokerMessageHandler.class);
    @Autowired
    private MessageDispatcher router;
    @Autowired
    private BrokerService brokerService;
    @Autowired
    private AppearanceListBean appearanceListBean;
    @Autowired
    private VisualizerBean vizBean;
    @Autowired
    private PushService pushService;
    @Autowired
    private GradingService gradingBean;

    public void initialize() {
        for (Class clazz : Arrays.asList(Competition.class, TariffSpecification.class, CashPosition.class, TariffTransaction.class, DistributionTransaction.class, BalancingTransaction.class)) {
            this.router.registerMessageHandler((Object)this, clazz);
        }
    }

    public void handleMessage(Competition competition) {
        List brokersName = competition.getBrokers();
        ArrayList<BrokerModel> list = new ArrayList<BrokerModel>();
        ConcurrentHashMap<String, BrokerModel> map = new ConcurrentHashMap<String, BrokerModel>(10, 0.75f, 1);
        for (String name : brokersName) {
            BrokerModel brokerModel = new BrokerModel(name, this.appearanceListBean.getAppereance());
            list.add(brokerModel);
            map.put(brokerModel.getName(), brokerModel);
        }
        this.brokerService.setBrokersMap(map);
        this.brokerService.setBrokers(list);
        this.vizBean.setCompetition(competition);
        this.vizBean.setRunning(true);
        this.vizBean.setFinished(false);
        this.pushService.pushInfoMessage(new InfoPush("start"));
        this.pushService.pushInfoMessage(new InfoPush(competition.getName()));
    }

    public void handleMessage(TariffSpecification tariffSpecification) {
        BrokerModel brokerModel;
        if (tariffSpecification.getSupersedes() != null) {
            this.log.debug("NO of tariffspec:" + tariffSpecification.getSupersedes().size());
        }
        if ((brokerModel = this.brokerService.findBrokerByName(tariffSpecification.getBroker().getUsername())) != null) {
            brokerModel.getTariffCategory().processTariffSpecification(tariffSpecification);
        }
    }

    public void handleMessage(CashPosition msg) {
        BrokerModel broker = this.brokerService.findBrokerByName(msg.getBroker().getUsername());
        if (broker != null) {
            FinanceCategory fc = broker.getFinanceCategory();
            int tsIndex = this.vizBean.getCurrentTimeslotSerialNumber();
            ConcurrentHashMap fddMap = fc.getFinanceDynamicDataMap();
            if (!fddMap.containsKey(tsIndex)) {
                FinanceDynamicData fdd = new FinanceDynamicData(fc.getProfit(), tsIndex);
                fc.setLastFinanceDynamicData(fdd);
                fddMap.put(tsIndex, fdd);
            }
            ((FinanceDynamicData)fddMap.get(tsIndex)).updateProfit(msg.getBalance());
            fc.setProfit(msg.getBalance());
        }
    }

    public void handleMessage(TariffTransaction msg) {
        BrokerModel broker = this.brokerService.findBrokerByName(msg.getBroker().getUsername());
        if (broker != null) {
            this.gradingBean.addCharge(Math.abs(msg.getCharge()));
            if (msg.getTxType() == TariffTransaction.Type.SIGNUP) {
                broker.getTariffCategory().addCustomers(msg.getCustomerCount());
            }
            if (msg.getTxType() == TariffTransaction.Type.CONSUME) {
                this.gradingBean.addSoldEnergyTariffMarket(Math.abs(msg.getKWh()));
                broker.getTariffCategory().addConsumptionConsumers((long)msg.getCustomerCount());
                broker.getTariffCategory().addSoldEnergy(Math.abs(msg.getKWh()));
                broker.getTariffCategory().addMoneyFromSold(msg.getCharge());
            }
            if (msg.getTxType() == TariffTransaction.Type.PRODUCE) {
                this.gradingBean.addBoughtEnergyTariffMarket(msg.getKWh());
                broker.getTariffCategory().addBoughtEnergy(msg.getKWh());
            }
            TariffCategory tc = broker.getTariffCategory();
            tc.addCharge(Math.abs(msg.getCharge()));
            int tsIndex = msg.getPostedTimeslotIndex();
            ConcurrentHashMap tddmap = tc.getTariffDynamicDataMap();
            if (!tddmap.containsKey(tsIndex)) {
                TariffDynamicData tdd = new TariffDynamicData(tsIndex, tc.getProfit(), tc.getEnergy(), tc.getCustomerCount());
                tc.addTariffDynamicData(tdd);
            }
            tc.update(tsIndex, msg.getKWh(), msg.getCharge(), Helper.getCustomerCount((TariffTransaction)msg));
            if (broker != null) {
                broker.getTariffCategory().processTariffSpecification(msg.getTariffSpec());
            }
            ((TariffData)tc.getTariffData().get(msg.getTariffSpec())).setCustomers((long)Helper.getCustomerCount((TariffTransaction)msg));
            ((TariffData)broker.getTariffCategory().getTariffData().get(msg.getTariffSpec())).processTariffTx(msg);
        }
    }

    public void handleMessage(DistributionTransaction msg) {
        BrokerModel broker = this.brokerService.findBrokerByName(msg.getBroker().getUsername());
        if (broker != null) {
            DistributionCategory dc = broker.getDistributionCategory();
            dc.update(msg.getPostedTimeslotIndex(), msg.getKWh(), msg.getCharge());
            this.gradingBean.addEnergyDistribution(Math.abs(msg.getKWh()));
        }
    }

    public void handleMessage(BalancingTransaction bt) {
        BrokerModel broker = this.brokerService.findBrokerByName(bt.getBroker().getUsername());
        if (broker != null) {
            BalancingCategory bc = broker.getBalancingCategory();
            bc.update(bt.getPostedTimeslotIndex(), bt.getKWh(), bt.getCharge());
        }
    }
}

