/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.statistical;

import org.powertac.common.MarketTransaction;
import org.powertac.common.Order;
import org.powertac.visualizer.domain.broker.BrokerModel;

public class WholesaleData {
    private BrokerModel broker;
    private double priceOrder;
    private double energyOrder;
    private double priceTx;
    private double energyTx;

    public WholesaleData(BrokerModel broker, Order order) {
        this.broker = broker;
        this.priceOrder = order.getLimitPrice();
        this.energyOrder = order.getMWh();
    }

    public void setBroker(BrokerModel broker) {
        this.broker = broker;
    }

    public void processMarketTransaction(MarketTransaction tx) {
        this.energyTx = tx.getMWh();
        this.priceTx = tx.getPrice();
    }

    public BrokerModel getBroker() {
        return this.broker;
    }

    public double getEnergyOrder() {
        return this.energyOrder;
    }

    public double getEnergyTx() {
        return this.energyTx;
    }

    public double getPriceOrder() {
        return this.priceOrder;
    }

    public double getPriceTx() {
        return this.priceTx;
    }
}

