/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services;

import org.powertac.visualizer.interfaces.Recyclable;
import org.springframework.stereotype.Service;

@Service
public class GradingService
implements Recyclable {
    private double totalSoldEnergyTariffMarket;
    private double totalBoughtEnergyTariffMarket;
    private double totalMoneyFlowTariffMarket;
    private double totalDistributionTariffMarket;
    private double totalBoughtEnergyWholesaleMarket;
    private double totalSoldEnergyWholesaleMarket;
    private double totalMoneyFromSellingWholesaleMarket;
    private double totalMoneyFromBuyingWholesaleMarket;

    public double getTariffGrade(double moneyFlow, long consumptionConsumers, double moneySoldEnergy, double boughtEnergy, double soldEnergy, int customerCount, int lostCustomers) {
        double gradeProfit = this.totalMoneyFlowTariffMarket != 0.0 ? moneyFlow / this.totalMoneyFlowTariffMarket : 0.0;
        double gradeTariffSellShare = this.totalBoughtEnergyTariffMarket != 0.0 ? boughtEnergy / this.totalBoughtEnergyTariffMarket : 0.0;
        double gradeTariffBuyShare = this.totalSoldEnergyTariffMarket != 0.0 ? soldEnergy / this.totalSoldEnergyTariffMarket : 0.0;
        return 33.0 * gradeProfit + 33.0 * gradeTariffSellShare + 33.0 * gradeTariffBuyShare;
    }

    public double getDistributionGrade(double energy) {
        return this.totalDistributionTariffMarket != 0.0 ? energy / this.totalDistributionTariffMarket * 100.0 : 0.0;
    }

    public double getWholesaleGrade(double totalRevenue, double totalCost, double energyBought, double energySold) {
        double percentageRevenue;
        double percentageCost;
        double totalAggregateCost = this.totalBoughtEnergyWholesaleMarket != 0.0 ? energyBought / this.totalBoughtEnergyWholesaleMarket * this.totalMoneyFromBuyingWholesaleMarket : 0.0;
        double totalAggregateRevenue = this.totalSoldEnergyWholesaleMarket != 0.0 ? energySold / this.totalSoldEnergyWholesaleMarket * this.totalMoneyFromSellingWholesaleMarket : 0.0;
        double wholesaleGradeCost = 50.0;
        double d = percentageCost = totalAggregateCost != 0.0 ? Math.abs(totalCost) / Math.abs(totalAggregateCost) : 0.0;
        if (percentageCost > 1.0) {
            wholesaleGradeCost -= (percentageCost - 1.0) * 100.0 / 2.0;
        } else if (percentageCost < 1.0) {
            wholesaleGradeCost += (1.0 - percentageCost) * 100.0 / 2.0;
        }
        double wholesaleGradeRevenue = 50.0;
        double d2 = percentageRevenue = totalAggregateRevenue != 0.0 ? Math.abs(totalRevenue) / Math.abs(totalAggregateRevenue) : 0.0;
        if (percentageRevenue > 1.0) {
            wholesaleGradeRevenue += (percentageRevenue - 1.0) * 100.0 / 2.0;
        } else if (percentageRevenue < 1.0) {
            wholesaleGradeRevenue -= (1.0 - percentageRevenue) * 100.0 / 2.0;
        }
        return wholesaleGradeCost / 2.0 + wholesaleGradeRevenue / 2.0;
    }

    public double getBalancingGrade(double balancedEnergy, double energyDelivered, double cost) {
        double imbalanceRatio = energyDelivered != 0.0 ? balancedEnergy / energyDelivered : 0.0;
        double costPerkWh = balancedEnergy != 0.0 ? cost / balancedEnergy : 0.0;
        double gradeRatio = 0.0;
        if (Math.abs(imbalanceRatio) <= 1.0) {
            gradeRatio = (1.0 - Math.abs(imbalanceRatio)) * 100.0;
        }
        double gradeCostPerkWh = 50.0;
        if (costPerkWh < 0.0 && costPerkWh > -0.05) {
            gradeCostPerkWh += costPerkWh * 1000.0;
        } else if (costPerkWh <= -0.05) {
            gradeCostPerkWh = 0.0;
        } else if (costPerkWh > 0.0 && costPerkWh < 0.05) {
            gradeCostPerkWh += costPerkWh * 1000.0;
        } else if (costPerkWh >= 0.05) {
            gradeCostPerkWh = 50.0;
        }
        return gradeRatio / 2.0 + gradeCostPerkWh / 2.0;
    }

    public double getImbalanceRatio(double balancedEnergy, double energyDelivered) {
        return energyDelivered != 0.0 ? balancedEnergy / energyDelivered : 0.0;
    }

    public double getTotalMoneyFlow() {
        return this.totalMoneyFlowTariffMarket;
    }

    public void addCharge(double charge) {
        this.totalMoneyFlowTariffMarket += charge;
    }

    public double getTotalSoldEnergyTariffMarket() {
        return this.totalSoldEnergyTariffMarket;
    }

    public void addSoldEnergyTariffMarket(double soldEnergyTariffMarket) {
        this.totalSoldEnergyTariffMarket += soldEnergyTariffMarket;
    }

    public double getTotalBoughtEnergyTariffMarket() {
        return this.totalBoughtEnergyTariffMarket;
    }

    public void addBoughtEnergyTariffMarket(double boughtEnergyTariffMarket) {
        this.totalBoughtEnergyTariffMarket += boughtEnergyTariffMarket;
    }

    public double getTotalDistribution() {
        return this.totalDistributionTariffMarket;
    }

    public void addEnergyDistribution(double energy) {
        this.totalDistributionTariffMarket += energy;
    }

    public double getTotalBoughtEnergyWholesaleMarket() {
        return this.totalBoughtEnergyWholesaleMarket;
    }

    public void addBoughtEnergyWholesaleMarket(double energy) {
        this.totalBoughtEnergyWholesaleMarket += energy;
    }

    public double getTotalSoldEnergyWholesaleMarket() {
        return this.totalSoldEnergyWholesaleMarket;
    }

    public void addSoldEnergyWholesaleMarket(double energy) {
        this.totalSoldEnergyWholesaleMarket += energy;
    }

    public double getTotalMoneyFromSellingWholesaleMarket() {
        return this.totalMoneyFromSellingWholesaleMarket;
    }

    public void addMoneyFromSellingWholesaleMarket(double money) {
        this.totalMoneyFromSellingWholesaleMarket += money;
    }

    public double getTotalMoneyFromBuyingWholesaleMarket() {
        return this.totalMoneyFromBuyingWholesaleMarket;
    }

    public void addMoneyFromBuyingWholesaleMarket(double money) {
        this.totalMoneyFromBuyingWholesaleMarket += money;
    }

    public void recycle() {
        this.totalBoughtEnergyTariffMarket = 0.0;
        this.totalBoughtEnergyWholesaleMarket = 0.0;
        this.totalDistributionTariffMarket = 0.0;
        this.totalMoneyFlowTariffMarket = 0.0;
        this.totalMoneyFromBuyingWholesaleMarket = 0.0;
        this.totalMoneyFromSellingWholesaleMarket = 0.0;
        this.totalSoldEnergyTariffMarket = 0.0;
        this.totalSoldEnergyWholesaleMarket = 0.0;
    }
}

