/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.services;

import com.google.gson.Gson;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.WeatherForecast;
import org.powertac.common.WeatherReport;
import org.powertac.visualizer.beans.VisualizerBean;
import org.powertac.visualizer.interfaces.Recyclable;
import org.powertac.visualizer.interfaces.TimeslotCompleteActivation;
import org.powertac.visualizer.push.WeatherPusher;
import org.powertac.visualizer.services.handlers.VisualizerHelperService;
import org.primefaces.push.EventBus;
import org.primefaces.push.EventBusFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeatherInfoService
implements Recyclable,
TimeslotCompleteActivation {
    private static Logger log = LogManager.getLogger(WeatherInfoService.class);
    private ConcurrentHashMap<Integer, WeatherReport> reports;
    private WeatherReport currentReport;
    private WeatherForecast currentForecast;
    @Autowired
    private VisualizerHelperService helper;
    @Autowired
    private VisualizerBean visualizerBean;

    public WeatherInfoService() {
        this.recycle();
    }

    public void recycle() {
        this.reports = new ConcurrentHashMap(1000, 0.75f, 1);
        this.currentForecast = null;
        this.currentReport = null;
    }

    public WeatherReport getCurrentReport() {
        return this.currentReport;
    }

    public void setCurrentReport(WeatherReport currentReport) {
        this.currentReport = currentReport;
    }

    public WeatherForecast getCurrentForecast() {
        return this.currentForecast;
    }

    public void setCurrentForecast(WeatherForecast currentForecast) {
        this.currentForecast = currentForecast;
    }

    public ConcurrentHashMap<Integer, WeatherReport> getReports() {
        return this.reports;
    }

    public void addReport(WeatherReport weatherReport) {
        this.currentReport = weatherReport;
        this.reports.put(weatherReport.getCurrentTimeslot().getSerialNumber(), weatherReport);
    }

    public void activate(int timeslotIndex, Instant postedTime) {
        if (this.currentReport != null) {
            EventBus pushContext = EventBusFactory.getDefault().eventBus();
            Gson gson = new Gson();
            WeatherPusher weather = new WeatherPusher(this.helper.getMillisForIndex(this.currentReport.getCurrentTimeslot().getSerialNumber()), this.currentReport.getTemperature(), this.currentReport.getWindSpeed(), this.currentReport.getWindDirection(), this.currentReport.getCloudCover(), this.currentReport.getTimeslotIndex());
            this.visualizerBean.setWeatherPusher(weather);
            String weatherReportPush = gson.toJson((Object)weather);
            pushContext.publish("/weather", (Object)weatherReportPush);
        }
    }
}

