/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.statistical;

import java.util.concurrent.ConcurrentHashMap;
import org.powertac.common.CustomerInfo;
import org.powertac.common.TariffSpecification;
import org.powertac.visualizer.domain.broker.BrokerModel;
import org.powertac.visualizer.domain.broker.CustomerTariffData;
import org.powertac.visualizer.domain.broker.TariffData;
import org.powertac.visualizer.domain.broker.TariffDynamicData;
import org.powertac.visualizer.statistical.AbstractPerformanceCategory;
import org.powertac.visualizer.statistical.PerformanceCategory;

public class TariffCategory
extends AbstractPerformanceCategory
implements PerformanceCategory {
    private double totalSoldEnergy;
    private double totalBoughtEnergy;
    private double totalMoneyFlow;
    private int gainedCustomers;
    private int lostCustomers;
    private long consumptionConsumers;
    private double totalMoneyFromSold;
    private int customerCount;
    private TariffDynamicData lastTariffDynamicData = new TariffDynamicData(0, 0.0, 0.0, 0);
    private ConcurrentHashMap<Integer, TariffDynamicData> tariffDynamicDataMap = new ConcurrentHashMap(1000, 0.75f, 1);
    private ConcurrentHashMap<CustomerInfo, CustomerTariffData> customerTariffData = new ConcurrentHashMap(20, 0.75f, 1);
    private ConcurrentHashMap<TariffSpecification, TariffData> tariffData = new ConcurrentHashMap(20, 0.75f, 1);

    public TariffCategory(BrokerModel broker) {
        super(broker);
    }

    public void processTariffSpecification(TariffSpecification ts) {
        this.tariffData.putIfAbsent(ts, new TariffData(ts, this.getBroker()));
    }

    public int getCustomerCount() {
        return this.customerCount;
    }

    public ConcurrentHashMap<Integer, TariffDynamicData> getTariffDynamicDataMap() {
        return this.tariffDynamicDataMap;
    }

    public ConcurrentHashMap<CustomerInfo, CustomerTariffData> getCustomerTariffData() {
        return this.customerTariffData;
    }

    public ConcurrentHashMap<TariffSpecification, TariffData> getTariffData() {
        return this.tariffData;
    }

    public void update(int tsIndex, double energy, double cash, int customerDelta) {
        this.customerCount += customerDelta;
        ((TariffDynamicData)this.tariffDynamicDataMap.get(tsIndex)).update(cash, energy, customerDelta);
        this.update(tsIndex, energy, cash);
    }

    public void addTariffDynamicData(TariffDynamicData tdd) {
        this.lastTariffDynamicData = tdd;
        this.tariffDynamicDataMap.put(tdd.getDynamicData().getTsIndex(), tdd);
    }

    public TariffDynamicData getLastTariffDynamicData() {
        return this.lastTariffDynamicData;
    }

    public double getTotalMoneyFlow() {
        return this.totalMoneyFlow;
    }

    public void addCharge(double charge) {
        this.totalMoneyFlow += charge;
    }

    public int getGainedCustomers() {
        return this.gainedCustomers;
    }

    public void addCustomers(int gainedCustomers) {
        this.gainedCustomers = gainedCustomers;
    }

    public int getLostCustomers() {
        return this.lostCustomers;
    }

    public void addLostCustomers(int lostCustomers) {
        this.lostCustomers += lostCustomers;
    }

    public long getConsumptionConsumers() {
        return this.consumptionConsumers;
    }

    public void addConsumptionConsumers(long consumptionConsumers) {
        this.consumptionConsumers += consumptionConsumers;
    }

    public double getTotalSoldEnergy() {
        return this.totalSoldEnergy;
    }

    public void addSoldEnergy(double soldEnergy) {
        this.totalSoldEnergy += soldEnergy;
    }

    public double getTotalBoughtEnergy() {
        return this.totalBoughtEnergy;
    }

    public void addBoughtEnergy(double boughtEnergy) {
        this.totalBoughtEnergy += boughtEnergy;
    }

    public double getTotalMoneyFromSold() {
        return this.totalMoneyFromSold;
    }

    public void addMoneyFromSold(double moneyFromSold) {
        this.totalMoneyFromSold += moneyFromSold;
    }
}

