/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import org.powertac.visualizer.config.ApplicationProperties;
import org.powertac.visualizer.config.DefaultProfileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.MetricFilterAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.MetricRepositoryAutoConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.jms.JmsAutoConfiguration;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@ImportResource(value={"classpath:powertac.xml", "classpath:logtool.xml"})
@ComponentScan(value={"org.powertac.visualizer"})
@EnableAutoConfiguration(exclude={MetricFilterAutoConfiguration.class, MetricRepositoryAutoConfiguration.class, JmsAutoConfiguration.class})
@EnableConfigurationProperties(value={LiquibaseProperties.class, ApplicationProperties.class})
@EnableScheduling
public class Visualizer2App {
    private static final Logger log = LoggerFactory.getLogger(Visualizer2App.class);
    private final Environment env;

    public Visualizer2App(Environment env) {
        this.env = env;
    }

    @PostConstruct
    public void initApplication() {
        List<String> activeProfiles = Arrays.asList(this.env.getActiveProfiles());
        if (activeProfiles.contains("dev") && activeProfiles.contains("prod")) {
            log.error("You have misconfigured your application! It should not run with both the 'dev' and 'prod' profiles at the same time.");
        }
        if (activeProfiles.contains("dev") && activeProfiles.contains("cloud")) {
            log.error("You have misconfigured your application! It should notrun with both the 'dev' and 'cloud' profiles at the same time.");
        }
    }

    public static void main(String[] args) throws UnknownHostException {
        SpringApplication app = new SpringApplication(new Object[]{Visualizer2App.class});
        DefaultProfileUtil.addDefaultProfile((SpringApplication)app);
        ConfigurableEnvironment env = app.run(args).getEnvironment();
        String protocol = "http";
        if (env.getProperty("server.ssl.key-store") != null) {
            protocol = "https";
        }
        log.info("\n----------------------------------------------------------\n\tApplication '{}' is running! Access URLs:\n\tLocal: \t\t{}://localhost:{}\n\tExternal: \t{}://{}:{}\n\tProfile(s): \t{}\n----------------------------------------------------------", new Object[]{env.getProperty("spring.application.name"), protocol, env.getProperty("server.port"), protocol, InetAddress.getLocalHost().getHostAddress(), env.getProperty("server.port"), env.getActiveProfiles()});
    }
}

