/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.powertac.visualizer.domain.User;
import org.powertac.visualizer.domain.enumeration.FileType;

@Entity
@Table(name="file")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class File
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String separator = java.io.File.separator;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="type", nullable=false)
    private FileType type;
    @NotNull
    @Size(min=1, max=255)
    @Column(name="name", length=255, nullable=false)
    private String name;
    @NotNull
    @Column(name="shared", nullable=false)
    private Boolean shared;
    @ManyToOne
    private User owner;

    public static final String getSafeName(String name) {
        try {
            name = name == null ? null : URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public FileType getType() {
        return this.type;
    }

    public void setType(FileType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean isShared() {
        return this.shared;
    }

    public void setShared(Boolean shared) {
        this.shared = shared;
    }

    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User user) {
        this.owner = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        File file = (File)o;
        if (file.id == null || this.id == null) {
            return false;
        }
        return Objects.equals(this.id, file.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public String toString() {
        return "File{id=" + this.id + ", type='" + this.type + "', name='" + this.name + "', shared='" + this.shared + "'" + '}';
    }

    public boolean exists() {
        return this.exists(this.getOwner());
    }

    public boolean exists(User user) {
        return this.getType().getFile(user, this.getName()).exists();
    }

    public boolean delete() {
        return this.delete(this.getOwner());
    }

    public boolean delete(User user) {
        return this.getType().getFile(user, this.getName()).delete();
    }

    public String getPath() {
        return this.getPath(this.getOwner());
    }

    public String getPath(User user) {
        FileType type = this.getType();
        java.io.File raw = type == null ? null : type.getFile(user, this.getName());
        return raw == null ? null : raw.getPath();
    }
}

