/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain.enumeration;

import java.io.File;
import org.powertac.visualizer.domain.User;
import org.powertac.visualizer.domain.enumeration.FileType;

public enum FileType {
    TRACE,
    STATE,
    SEED,
    BOOT,
    CONFIG,
    WEATHER,
    ANY;

    public static final String DIRECTORY_ROOT = "files";
    public static final String DIRECTORY_LOG = "log";
    public static final String DIRECTORY_SEED = "seed";
    public static final String DIRECTORY_BOOT = "boot";
    public static final String DIRECTORY_CONFIG = "config";
    public static final String DIRECTORY_WEATHER = "weather";

    public final String getContentType() {
        if (this.equals((Object)ANY)) {
            throw new IllegalArgumentException();
        }
        switch (1.$SwitchMap$org$powertac$visualizer$domain$enumeration$FileType[this.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return "text/plain";
            }
        }
        return "application/xml";
    }

    public final File getDirectory(User user) {
        if (this.equals((Object)ANY)) {
            throw new IllegalArgumentException();
        }
        File directory = new File(DIRECTORY_ROOT);
        directory = user != null ? new File(directory, user.getLogin()) : new File(directory, "system");
        switch (1.$SwitchMap$org$powertac$visualizer$domain$enumeration$FileType[this.ordinal()]) {
            case 1: 
            case 2: {
                directory = new File(directory, DIRECTORY_LOG);
                break;
            }
            case 3: {
                directory = new File(directory, DIRECTORY_SEED);
                break;
            }
            case 5: {
                directory = new File(directory, DIRECTORY_BOOT);
                break;
            }
            case 4: {
                directory = new File(directory, DIRECTORY_CONFIG);
                break;
            }
            case 6: {
                directory = new File(directory, DIRECTORY_WEATHER);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled case " + this);
            }
        }
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return directory;
    }

    public final File getFile(User user, String name) {
        return name == null ? null : new File(this.getDirectory(user), name);
    }
}

