/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.repository;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import org.powertac.visualizer.config.audit.AuditEventConverter;
import org.powertac.visualizer.domain.PersistentAuditEvent;
import org.powertac.visualizer.repository.PersistenceAuditEventRepository;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CustomAuditEventRepository
implements AuditEventRepository {
    private static final String AUTHORIZATION_FAILURE = "AUTHORIZATION_FAILURE";
    private final PersistenceAuditEventRepository persistenceAuditEventRepository;
    private final AuditEventConverter auditEventConverter;

    public CustomAuditEventRepository(PersistenceAuditEventRepository persistenceAuditEventRepository, AuditEventConverter auditEventConverter) {
        this.persistenceAuditEventRepository = persistenceAuditEventRepository;
        this.auditEventConverter = auditEventConverter;
    }

    public List<AuditEvent> find(Date after) {
        List persistentAuditEvents = this.persistenceAuditEventRepository.findByAuditEventDateAfter(LocalDateTime.from(after.toInstant()));
        return this.auditEventConverter.convertToAuditEvent((Iterable)persistentAuditEvents);
    }

    public List<AuditEvent> find(String principal, Date after) {
        List persistentAuditEvents = principal == null && after == null ? this.persistenceAuditEventRepository.findAll() : (after == null ? this.persistenceAuditEventRepository.findByPrincipal(principal) : this.persistenceAuditEventRepository.findByPrincipalAndAuditEventDateAfter(principal, LocalDateTime.from(after.toInstant())));
        return this.auditEventConverter.convertToAuditEvent((Iterable)persistentAuditEvents);
    }

    public List<AuditEvent> find(String principal, Date after, String type) {
        List persistentAuditEvents = this.persistenceAuditEventRepository.findByPrincipalAndAuditEventDateAfterAndAuditEventType(principal, LocalDateTime.from(after.toInstant()), type);
        return this.auditEventConverter.convertToAuditEvent((Iterable)persistentAuditEvents);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void add(AuditEvent event) {
        if (!AUTHORIZATION_FAILURE.equals(event.getType()) && !"anonymoususer".equals(event.getPrincipal())) {
            PersistentAuditEvent persistentAuditEvent = new PersistentAuditEvent();
            persistentAuditEvent.setPrincipal(event.getPrincipal());
            persistentAuditEvent.setAuditEventType(event.getType());
            Instant instant = Instant.ofEpochMilli(event.getTimestamp().getTime());
            persistentAuditEvent.setAuditEventDate(LocalDateTime.ofInstant(instant, ZoneId.systemDefault()));
            persistentAuditEvent.setData(this.auditEventConverter.convertDataToStrings(event.getData()));
            this.persistenceAuditEventRepository.save((Object)persistentAuditEvent);
        }
    }
}

