/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.service;

import java.io.Serializable;
import java.util.List;
import org.powertac.visualizer.domain.File;
import org.powertac.visualizer.domain.Game;
import org.powertac.visualizer.domain.enumeration.GameType;
import org.powertac.visualizer.repository.GameRepository;
import org.powertac.visualizer.service.FileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GameService {
    private final Logger log = LoggerFactory.getLogger(GameService.class);
    private final GameRepository gameRepository;
    private final FileService fileService;

    public GameService(GameRepository gameRepository, FileService fileService) {
        this.gameRepository = gameRepository;
        this.fileService = fileService;
    }

    public Game save(Game game) {
        this.log.debug("Request to save Game : {}", (Object)game);
        Game result = (Game)this.gameRepository.save((Object)game);
        return result;
    }

    @Transactional(readOnly=true)
    public Page<Game> findAll(Pageable pageable) {
        this.log.debug("Request to get all Games");
        Page result = this.gameRepository.findAll(pageable);
        return result;
    }

    @Transactional(readOnly=true)
    public List<Game> findByOwnerIsCurrentUserOrShared(String login) {
        this.log.debug("Request to get all owned and shared Games");
        List result = this.gameRepository.findByOwnerIsCurrentUserOrShared(login);
        return result;
    }

    @Transactional(readOnly=true)
    public List<Game> findByNameAndType(String login, String name, GameType type) {
        this.log.debug("Request to get Game : {}", (Object)name, (Object)type.toString());
        List result = this.gameRepository.findByNameAndType(login, name, type);
        return result;
    }

    @Transactional(readOnly=true)
    public Game findOne(Long id) {
        this.log.debug("Request to get Game : {}", (Object)id);
        Game game = (Game)this.gameRepository.findOne((Serializable)id);
        return game;
    }

    @Transactional(readOnly=true)
    public List<Game> findByAssociatedFile(File file) {
        this.log.debug("Request to get Game : {}", (Object)file.getName());
        List result = this.gameRepository.findByAssociatedFile(file);
        return result;
    }

    public void delete(Long id) {
        this.log.debug("Request to delete Game : {}", (Object)id);
        Game game = (Game)this.gameRepository.findOne((Serializable)id);
        Long fileId = game.getStateFileId();
        if (fileId != null) {
            this.fileService.delete(fileId);
        }
        if ((fileId = game.getTraceFileId()) != null) {
            this.fileService.delete(fileId);
        }
        if (game.getType().equals((Object)GameType.BOOT) && (fileId = game.getBootFileId()) != null) {
            this.fileService.delete(fileId);
        }
        this.gameRepository.delete((Serializable)id);
    }
}

