/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.web.rest;

import com.codahale.metrics.annotation.Timed;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.powertac.visualizer.web.rest.vm.LoggerVM;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/management"})
public class LogsResource {
    @GetMapping(value={"/logs"})
    @Timed
    public List<LoggerVM> getList() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        return new TreeSet(config.getLoggers().keySet()).stream().map(LogManager::getLogger).map(LoggerVM::new).collect(Collectors.toList());
    }

    @PutMapping(value={"/logs"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Timed
    public void changeLevel(@RequestBody LoggerVM jsonLogger) {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        LoggerConfig logger = config.getLoggerConfig(jsonLogger.getName());
        logger.setLevel(Level.toLevel((String)jsonLogger.getLevel()));
        context.updateLoggers();
    }
}

