/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.config;

import com.fasterxml.jackson.datatype.hibernate5.Hibernate5Module;
import io.github.jhipster.config.liquibase.AsyncSpringLiquibase;
import java.sql.SQLException;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.h2.tools.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableJpaRepositories(value={"org.powertac.visualizer.repository"})
@EnableJpaAuditing(auditorAwareRef="springSecurityAuditorAware")
@EnableTransactionManagement
public class DatabaseConfiguration {
    private final Logger log = LoggerFactory.getLogger(DatabaseConfiguration.class);
    private final Environment env;

    public DatabaseConfiguration(Environment env) {
        this.env = env;
    }

    @Bean(initMethod="start", destroyMethod="stop")
    @Profile(value={"dev"})
    public Server h2TCPServer() throws SQLException {
        return Server.createTcpServer((String[])new String[]{"-tcp", "-tcpAllowOthers"});
    }

    @Bean
    public SpringLiquibase liquibase(@Qualifier(value="taskExecutor") TaskExecutor taskExecutor, DataSource dataSource, LiquibaseProperties liquibaseProperties) {
        AsyncSpringLiquibase liquibase = new AsyncSpringLiquibase(taskExecutor, this.env);
        liquibase.setDataSource(dataSource);
        liquibase.setChangeLog("classpath:config/liquibase/master.xml");
        liquibase.setContexts(liquibaseProperties.getContexts());
        liquibase.setDefaultSchema(liquibaseProperties.getDefaultSchema());
        liquibase.setDropFirst(liquibaseProperties.isDropFirst());
        if (this.env.acceptsProfiles(new String[]{"no-liquibase"})) {
            liquibase.setShouldRun(false);
        } else {
            liquibase.setShouldRun(liquibaseProperties.isEnabled());
            this.log.debug("Configuring Liquibase");
        }
        return liquibase;
    }

    @Bean
    public Hibernate5Module hibernate5Module() {
        return new Hibernate5Module();
    }
}

