/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.web.socket.config.annotation.AbstractWebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

@Configuration
@EnableWebSocketMessageBroker
public class WebsocketConfiguration
extends AbstractWebSocketMessageBrokerConfigurer {
    public static final String IP_ADDRESS = "IP_ADDRESS";

    public void configureClientOutboundChannel(ChannelRegistration registration) {
        registration.taskExecutor().corePoolSize(1);
    }

    public void configureMessageBroker(MessageBrokerRegistry config) {
        config.enableSimpleBroker(new String[]{"/topic"});
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/websocket/tracker"}).setHandshakeHandler((HandshakeHandler)new /* Unavailable Anonymous Inner Class!! */).withSockJS().setInterceptors(new HandshakeInterceptor[]{this.httpSessionHandshakeInterceptor()});
        registry.addEndpoint(new String[]{"/websocket/push"}).setAllowedOrigins(new String[]{"*"}).withSockJS();
    }

    @Bean
    public HandshakeInterceptor httpSessionHandshakeInterceptor() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

