/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain;

import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.powertac.visualizer.domain.File;
import org.powertac.visualizer.domain.User;
import org.powertac.visualizer.domain.enumeration.GameType;

@Entity
@Table(name="game")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Game
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="type", nullable=false)
    private GameType type;
    @NotNull
    @Size(min=1, max=255)
    @Column(name="name", length=255, nullable=false)
    private String name;
    @NotNull
    @Column(name="shared", nullable=false)
    private Boolean shared;
    @Column(name="date")
    private ZonedDateTime date;
    @Size(max=4095)
    @Column(name="brokers", length=4095)
    private String brokers;
    @ManyToOne
    private User owner;
    @ManyToOne
    private File traceFile;
    @ManyToOne
    private File stateFile;
    @ManyToOne
    private File seedFile;
    @ManyToOne
    private File bootFile;
    @ManyToOne
    private File configFile;
    @ManyToOne
    private File weatherFile;
    @Transient
    private List<String> brokerList;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public GameType getType() {
        return this.type;
    }

    public void setType(GameType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean isShared() {
        return this.shared;
    }

    public void setShared(Boolean shared) {
        this.shared = shared;
    }

    public ZonedDateTime getDate() {
        return this.date;
    }

    public void setDate(ZonedDateTime date) {
        this.date = date;
    }

    public String getBrokers() {
        return this.brokers;
    }

    public List<String> getBrokerList() {
        if (this.brokerList == null && this.brokers != null) {
            this.brokerList = Arrays.asList(this.brokers.split("\\s*,\\s*"));
        }
        return this.brokerList;
    }

    public void setBrokers(String brokers) {
        this.brokers = brokers;
        this.brokerList = null;
    }

    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User user) {
        this.owner = user;
    }

    public File getTraceFile() {
        return this.traceFile;
    }

    public String getTraceFileName() {
        return this.getFileName(this.getTraceFile());
    }

    public String getTraceFilePath() {
        return this.getFilePath(this.getTraceFile());
    }

    public Long getTraceFileId() {
        return this.getFileId(this.getTraceFile());
    }

    public void setTraceFile(File file) {
        this.traceFile = file;
    }

    public File getStateFile() {
        return this.stateFile;
    }

    public String getStateFileName() {
        return this.getFileName(this.getStateFile());
    }

    public String getStateFilePath() {
        return this.getFilePath(this.getStateFile());
    }

    public Long getStateFileId() {
        return this.getFileId(this.getStateFile());
    }

    public void setStateFile(File file) {
        this.stateFile = file;
    }

    public File getSeedFile() {
        return this.seedFile;
    }

    public String getSeedFileName() {
        return this.getFileName(this.getSeedFile());
    }

    public String getSeedFilePath() {
        return this.getFilePath(this.getSeedFile());
    }

    public Long getSeedFileId() {
        return this.getFileId(this.getSeedFile());
    }

    public void setSeedFile(File file) {
        this.seedFile = file;
    }

    public File getBootFile() {
        return this.bootFile;
    }

    public String getBootFileName() {
        return this.getFileName(this.getBootFile());
    }

    public String getBootFilePath() {
        return this.getFilePath(this.getBootFile());
    }

    public Long getBootFileId() {
        return this.getFileId(this.getBootFile());
    }

    public void setBootFile(File file) {
        this.bootFile = file;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public String getConfigFileName() {
        return this.getFileName(this.getConfigFile());
    }

    public String getConfigFilePath() {
        return this.getFilePath(this.getConfigFile());
    }

    public Long getConfigFileId() {
        return this.getFileId(this.getConfigFile());
    }

    public void setConfigFile(File file) {
        this.configFile = file;
    }

    public File getWeatherFile() {
        return this.weatherFile;
    }

    public String getWeatherFileName() {
        return this.getFileName(this.getWeatherFile());
    }

    public String getWeatherFilePath() {
        return this.getFilePath(this.getWeatherFile());
    }

    public Long getWeatherFileId() {
        return this.getFileId(this.getWeatherFile());
    }

    public void setWeatherFile(File file) {
        this.weatherFile = file;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Game game = (Game)o;
        if (game.id == null || this.id == null) {
            return false;
        }
        return Objects.equals(this.id, game.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public String toString() {
        return "Game{id=" + this.id + ", type='" + this.type + "', name='" + this.name + "', shared='" + this.shared + "', date='" + this.date + "', brokers='" + this.brokers + "'" + '}';
    }

    private String getFileName(File file) {
        return file == null ? null : file.getName();
    }

    private String getFilePath(File file) {
        return file == null ? null : file.getPath();
    }

    private Long getFileId(File file) {
        return file == null ? null : file.getId();
    }
}

