/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class RetailKPIHolder {
    @JsonProperty(value="sub")
    private int subscribedPopulation;
    private double kwh;
    @JsonProperty(value="m")
    private double money;
    @JsonProperty(value="actTx")
    private int activeTariffs;
    @JsonProperty(value="rvkTx")
    private int revokedTariffs;
    @JsonProperty(value="pubTx")
    private int publishedTariffs;

    public RetailKPIHolder() {
    }

    public RetailKPIHolder(RetailKPIHolder retailKPIHolder) {
        this.subscribedPopulation = retailKPIHolder.getSubscribedPopulation();
        this.kwh = retailKPIHolder.getKwh();
        this.money = retailKPIHolder.getMoney();
        this.activeTariffs = retailKPIHolder.getActiveTariffs();
        this.revokedTariffs = retailKPIHolder.getRevokedTariffs();
        this.publishedTariffs = retailKPIHolder.getPublishedTariffs();
    }

    public void signup(int population) {
        this.subscribedPopulation += population;
    }

    public void withdraw(int population) {
        this.subscribedPopulation -= population;
    }

    public void produceConsume(double txKwh, double txMoney) {
        this.kwh += txKwh;
        this.money += txMoney;
    }

    public void resetCurrentValues() {
        this.subscribedPopulation = 0;
        this.kwh = 0.0;
        this.money = 0.0;
        this.revokedTariffs = 0;
        this.publishedTariffs = 0;
    }

    public void incrementRevokedTariffs() {
        ++this.revokedTariffs;
    }

    public void incrementPublishedTariffs() {
        ++this.publishedTariffs;
    }

    public int getSubscribedPopulation() {
        return this.subscribedPopulation;
    }

    public void setSubscribedPopulation(int subscribedPopulation) {
        this.subscribedPopulation = subscribedPopulation;
    }

    public double getKwh() {
        return this.kwh;
    }

    public void setKwh(Double kwh) {
        this.kwh = kwh;
    }

    public Double getMoney() {
        return this.money;
    }

    public void setMoney(Double money) {
        this.money = money;
    }

    public int getActiveTariffs() {
        return this.activeTariffs;
    }

    public void setActiveTariffs(int activeTariffs) {
        this.activeTariffs = activeTariffs;
    }

    public int getRevokedTariffs() {
        return this.revokedTariffs;
    }

    public void setRevokedTariffs(int revokedTariffs) {
        this.revokedTariffs = revokedTariffs;
    }

    public int getPublishedTariffs() {
        return this.publishedTariffs;
    }

    public void setPublishedTariffs(int publishedTariffs) {
        this.publishedTariffs = publishedTariffs;
    }

    public String toString() {
        return "RetailKPIHolder [subscribedPopulationCum=, subscribedPopulation=" + this.subscribedPopulation + ", kwh=" + this.kwh + ", money=" + this.money + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RetailKPIHolder other = (RetailKPIHolder)obj;
        if (this.activeTariffs != other.activeTariffs) {
            return false;
        }
        if (Double.doubleToLongBits(this.kwh) != Double.doubleToLongBits(other.kwh)) {
            return false;
        }
        if (Double.doubleToLongBits(this.money) != Double.doubleToLongBits(other.money)) {
            return false;
        }
        if (this.publishedTariffs != other.publishedTariffs) {
            return false;
        }
        if (this.revokedTariffs != other.revokedTariffs) {
            return false;
        }
        return this.subscribedPopulation == other.subscribedPopulation;
    }
}

