/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.service_ptac;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import org.joda.time.Instant;
import org.powertac.common.Competition;
import org.springframework.stereotype.Service;

@Service
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
public class CompetitionService {
    private static long idCounter = 0L;
    private long id = idCounter++;
    private long idPowerTacCompetition;
    private String name;
    private String description;
    private int timeslotLength;
    private int bootstrapTimeslotCount;
    private int bootstrapDiscardedTimeslots;
    private int minimumTimeslotCount;
    private int expectedTimeslotCount;
    private int timeslotsOpen = 24;
    private int deactivateTimeslotsAhead = 1;
    private double minimumOrderQuantity;
    private Instant simulationBaseTime;
    private int timezoneOffset;
    private int latitude;
    private long simulationRate;
    private long simulationModulo;

    protected CompetitionService() {
    }

    public void setCurrent(Competition comp) {
        this.idPowerTacCompetition = comp.getId();
        this.name = comp.getName();
        this.description = comp.getDescription();
        this.timeslotLength = comp.getTimeslotLength();
        this.bootstrapTimeslotCount = comp.getBootstrapTimeslotCount();
        this.bootstrapDiscardedTimeslots = comp.getBootstrapDiscardedTimeslots();
        this.minimumTimeslotCount = comp.getMinimumTimeslotCount();
        this.expectedTimeslotCount = comp.getExpectedTimeslotCount();
        this.timeslotsOpen = comp.getTimeslotsOpen();
        this.deactivateTimeslotsAhead = comp.getDeactivateTimeslotsAhead();
        this.minimumOrderQuantity = comp.getMinimumOrderQuantity();
        this.simulationBaseTime = comp.getSimulationBaseTime();
        this.timezoneOffset = comp.getTimezoneOffset();
        this.latitude = comp.getLatitude();
        this.simulationRate = comp.getSimulationRate();
        this.simulationModulo = comp.getSimulationModulo();
    }

    public long getId() {
        return this.id;
    }

    public long getIdPowerTacCompetition() {
        return this.idPowerTacCompetition;
    }

    public long getTimeslotDuration() {
        return (long)this.timeslotLength * 60000L;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getTimeslotLength() {
        return this.timeslotLength;
    }

    public int getBootstrapTimeslotCount() {
        return this.bootstrapTimeslotCount;
    }

    public int getBootstrapDiscardedTimeslots() {
        return this.bootstrapDiscardedTimeslots;
    }

    public int getMinimumTimeslotCount() {
        return this.minimumTimeslotCount;
    }

    public int getExpectedTimeslotCount() {
        return this.expectedTimeslotCount;
    }

    public int getTimeslotsOpen() {
        return this.timeslotsOpen;
    }

    public int getDeactivateTimeslotsAhead() {
        return this.deactivateTimeslotsAhead;
    }

    public double getMinimumOrderQuantity() {
        return this.minimumOrderQuantity;
    }

    public Instant getSimulationBaseTime() {
        return this.simulationBaseTime;
    }

    public int getTimezoneOffset() {
        return this.timezoneOffset;
    }

    public int getLatitude() {
        return this.latitude;
    }

    public long getSimulationRate() {
        return this.simulationRate;
    }

    public long getSimulationModulo() {
        return this.simulationModulo;
    }
}

