/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.service_ptac;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.joda.time.Instant;
import org.powertac.common.CashPosition;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.TariffSpecification;
import org.powertac.common.TariffTransaction;
import org.powertac.common.msg.CustomerBootstrapData;
import org.powertac.common.msg.SimEnd;
import org.powertac.common.msg.SimPause;
import org.powertac.common.msg.SimResume;
import org.powertac.common.msg.SimStart;
import org.powertac.common.msg.TariffRevoke;
import org.powertac.common.msg.TimeslotComplete;
import org.powertac.common.msg.TimeslotUpdate;
import org.powertac.visualizer.domain.Broker;
import org.powertac.visualizer.domain.Customer;
import org.powertac.visualizer.domain.RetailKPIHolder;
import org.powertac.visualizer.domain.Tariff;
import org.powertac.visualizer.domain.TickSnapshot;
import org.powertac.visualizer.repository_ptac.BrokerRepository;
import org.powertac.visualizer.repository_ptac.CustomerRepository;
import org.powertac.visualizer.repository_ptac.TariffRepository;
import org.powertac.visualizer.repository_ptac.TickSnapshotRepository;
import org.powertac.visualizer.service_ptac.CompetitionService;
import org.powertac.visualizer.service_ptac.VisualizerService;
import org.powertac.visualizer.web.dto.InitMessage;
import org.powertac.visualizer.web.dto.TickValueBroker;
import org.powertac.visualizer.web.dto.TickValueCustomer;
import org.powertac.visualizer.web.websocket.Pusher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageHandler {
    private static Logger log = LoggerFactory.getLogger(MessageHandler.class);
    @Autowired
    private BrokerRepository brokerRepo;
    @Autowired
    private CustomerRepository customerRepo;
    @Autowired
    private TickSnapshotRepository tickSnapshotRepo;
    @Autowired
    private TariffRepository tariffRepo;
    @Autowired
    private VisualizerService visualizerService;
    @Autowired
    public Pusher pusher;
    @Autowired
    private CompetitionService currentCompetition;
    private int currentTimeslot = 0;
    private Instant currentInstant;

    public void initialize() {
    }

    public void handleMessage(Competition c) {
        Competition.setCurrent((Competition)c);
        this.currentCompetition.setCurrent(c);
        for (String n : c.getBrokers()) {
            Broker broker = new Broker(n);
            this.brokerRepo.save(broker);
        }
        for (CustomerInfo ci : c.getCustomers()) {
            Customer customer = new Customer(ci);
            this.customerRepo.save(customer);
        }
        this.currentInstant = null;
        log.info("VizCompetition received");
    }

    public void handleMessage(SimPause sp) {
    }

    public void handleMessage(SimResume sr) {
        log.trace("SimResume received");
    }

    public void handleMessage(SimStart ss) {
        log.debug("SimStart received - start time is " + ss.getStart().toString());
        this.visualizerService.setState(VisualizerService.VisualizerState.RUNNING);
    }

    public void handleMessage(SimEnd se) {
        log.info("SimEnd received");
        this.visualizerService.setState(VisualizerService.VisualizerState.FINISHED);
    }

    public synchronized void handleMessage(TimeslotUpdate tu) {
        if (this.currentInstant == null) {
            this.currentInstant = tu.getPostedTime();
            InitMessage initMessage = new InitMessage(this.visualizerService.getState(), this.currentCompetition, this.brokerRepo.findAll(), this.customerRepo.findAll(), this.tickSnapshotRepo.findAll());
            log.trace("handleMessage(TimeslotUpdate), about to make a call to pusher.sendInitMessage ");
            this.pusher.sendInitMessage(initMessage);
            return;
        }
        this.currentInstant = tu.getPostedTime();
        this.perTimeslotUpdate();
    }

    public synchronized void handleMessage(TimeslotComplete tc) {
        if (tc.getTimeslotIndex() == this.currentTimeslot) {
            this.notifyAll();
        }
    }

    public void handleMessage(CustomerBootstrapData cbd) {
        Customer customer = this.customerRepo.findByName(cbd.getCustomerName());
        customer.setBootstrapNetUsage(Arrays.stream(cbd.getNetUsage()).boxed().collect(Collectors.toList()));
    }

    public void handleMessage(CashPosition cp) {
        Broker broker;
        org.powertac.common.Broker ptacBroker = cp.getBroker();
        if (!ptacBroker.isWholesale() && (broker = this.brokerRepo.findByName(ptacBroker.getUsername())) != null) {
            broker.setCash(cp.getBalance());
        }
    }

    public synchronized void handleMessage(TariffSpecification spec) {
        Broker broker = this.brokerRepo.findByName(spec.getBroker().getUsername());
        if (broker != null) {
            Tariff tariff = new Tariff(broker, spec);
            this.tariffRepo.save(tariff);
            broker.getRetail().incrementPublishedTariffs();
        } else {
            log.error("VizBroker " + spec.getBroker() + " cannot be found.");
        }
    }

    public synchronized void handleMessage(TariffTransaction ttx) {
        try {
            Broker broker;
            TariffSpecification newSpec = ttx.getTariffSpec();
            if (newSpec == null) {
                log.error("TariffTransaction type={} for unknown spec", (Object)ttx.getTxType());
            } else {
                Tariff oldSpec = this.tariffRepo.findById(newSpec.getId());
                if (oldSpec == null && !newSpec.getBroker().getUsername().equals("default broker") && !TariffTransaction.Type.PUBLISH.equals((Object)ttx.getTxType())) {
                    log.error("Incoming spec {} for {} not matched in repo", (Object)newSpec.getId(), (Object)ttx.getBroker().getUsername());
                }
            }
            TariffTransaction.Type txType = ttx.getTxType();
            ArrayList<RetailKPIHolder> retailKPIHolders = new ArrayList<RetailKPIHolder>();
            Customer customer = null;
            if (ttx.getCustomerInfo() != null) {
                customer = this.customerRepo.findById(ttx.getCustomerInfo().getId());
            }
            if (customer != null) {
                retailKPIHolders.add(customer.getRetail());
            }
            if ((broker = this.brokerRepo.findByName(ttx.getBroker().getUsername())) != null) {
                retailKPIHolders.add(broker.getRetail());
            }
            Tariff tariff = null;
            if (newSpec != null) {
                tariff = this.tariffRepo.findById(newSpec.getId());
            }
            if (tariff != null) {
                retailKPIHolders.add(tariff.getRetail());
            }
            for (RetailKPIHolder record : retailKPIHolders) {
                if (TariffTransaction.Type.SIGNUP == txType) {
                    log.debug("SIGNUP:" + ttx.toString() + "cnt_customers:" + ttx.getCustomerCount());
                    record.signup(ttx.getCustomerCount());
                    continue;
                }
                if (TariffTransaction.Type.WITHDRAW == txType) {
                    log.debug("WITHDRAW:" + ttx.toString() + "cnt_customers:" + ttx.getCustomerCount());
                    record.withdraw(ttx.getCustomerCount());
                    continue;
                }
                if (TariffTransaction.Type.PRODUCE == txType) {
                    record.produceConsume(ttx.getKWh(), ttx.getCharge());
                    continue;
                }
                if (TariffTransaction.Type.CONSUME != txType) continue;
                record.produceConsume(ttx.getKWh(), ttx.getCharge());
            }
        }
        catch (NullPointerException npe) {
            StringBuilder stack = new StringBuilder();
            for (int i = 0; i < npe.getStackTrace().length; ++i) {
                stack.append(npe.getStackTrace()[i]);
            }
            log.error("TariffTransaction NPE:" + npe.getMessage() + " " + stack);
        }
    }

    public synchronized void handleMessage(TariffRevoke tr) {
        log.trace("Revoke tariff " + tr.getTariffId() + " from " + tr.getBroker().getUsername());
        Tariff tariff = this.tariffRepo.findById(tr.getTariffId());
        tariff.setActive(false);
        Broker broker = tariff.getBroker();
        broker.getRetail().incrementRevokedTariffs();
    }

    private void perTimeslotUpdate() {
        TickValueBroker tv;
        TickSnapshot ts = new TickSnapshot(this.currentInstant.getMillis());
        this.tickSnapshotRepo.save(ts);
        for (Broker broker : this.brokerRepo.findAll()) {
            tv = new TickValueBroker(broker, new RetailKPIHolder(broker.getRetail()));
            ts.getTickValueBrokers().add(tv);
            broker.getRetail().resetCurrentValues();
        }
        for (Customer customer : this.customerRepo.findAll()) {
            tv = new TickValueCustomer(customer.getId(), new RetailKPIHolder(customer.getRetail()));
            ts.getTickValueCustomers().add(tv);
            customer.getRetail().resetCurrentValues();
        }
        for (Tariff tariff : this.tariffRepo.findAll()) {
            tariff.getRetail().resetCurrentValues();
        }
        log.trace("perTimeslotUpdate(), about to make a call to pusher.sendTickSnapshotUpdates ");
        this.pusher.sendTickSnapshotUpdates(ts);
    }
}

