/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.service.dto;

import java.time.ZonedDateTime;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.powertac.visualizer.domain.Authority;
import org.powertac.visualizer.domain.User;

public class UserDTO {
    private Long id;
    @Pattern(regexp="^[_'.@A-Za-z0-9-]*$")
    @Size(min=1, max=50)
    private String login;
    @Size(max=50)
    private String firstName;
    @Size(max=50)
    private String lastName;
    @Size(min=2, max=5)
    private String langKey;
    private String createdBy;
    private ZonedDateTime createdDate;
    private String lastModifiedBy;
    private ZonedDateTime lastModifiedDate;
    private Set<String> authorities;

    public UserDTO() {
    }

    public UserDTO(User user) {
        this(user.getId(), user.getLogin(), user.getFirstName(), user.getLastName(), user.getLangKey(), user.getCreatedBy(), user.getCreatedDate(), user.getLastModifiedBy(), user.getLastModifiedDate(), user.getAuthorities().stream().map(Authority::getName).collect(Collectors.toSet()));
    }

    public UserDTO(Long id, String login, String firstName, String lastName, String langKey, String createdBy, ZonedDateTime createdDate, String lastModifiedBy, ZonedDateTime lastModifiedDate, Set<String> authorities) {
        this.id = id;
        this.login = login;
        this.firstName = firstName;
        this.lastName = lastName;
        this.langKey = langKey;
        this.createdBy = createdBy;
        this.createdDate = createdDate;
        this.lastModifiedBy = lastModifiedBy;
        this.lastModifiedDate = lastModifiedDate;
        this.authorities = authorities;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getLangKey() {
        return this.langKey;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public ZonedDateTime getCreatedDate() {
        return this.createdDate;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public ZonedDateTime getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(ZonedDateTime lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public Set<String> getAuthorities() {
        return this.authorities;
    }

    public String toString() {
        return "UserDTO{login='" + this.login + '\'' + ", firstName='" + this.firstName + '\'' + ", lastName='" + this.lastName + '\'' + ", langKey='" + this.langKey + '\'' + ", createdBy=" + this.createdBy + ", createdDate=" + this.createdDate + ", lastModifiedBy='" + this.lastModifiedBy + '\'' + ", lastModifiedDate=" + this.lastModifiedDate + ", authorities=" + this.authorities + "}";
    }
}

