/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.web.rest;

import com.codahale.metrics.annotation.Timed;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.powertac.visualizer.domain.Graph;
import org.powertac.visualizer.domain.User;
import org.powertac.visualizer.repository.UserRepository;
import org.powertac.visualizer.security.SecurityUtils;
import org.powertac.visualizer.service.GraphService;
import org.powertac.visualizer.web.rest.util.HeaderUtil;
import org.powertac.visualizer.web.rest.util.PaginationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class GraphResource {
    private final Logger log = LoggerFactory.getLogger(GraphResource.class);
    private static final String ENTITY_NAME = "graph";
    private final GraphService graphService;
    private final UserRepository userRepository;

    public GraphResource(GraphService graphService, UserRepository userRepository) {
        this.graphService = graphService;
        this.userRepository = userRepository;
    }

    @PostMapping(value={"/graphs"})
    @Timed
    public ResponseEntity<Graph> createGraph(@Valid @RequestBody Graph graph) throws URISyntaxException {
        this.log.debug("REST request to save Graph : {}", (Object)graph);
        if (graph.getId() != null) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().headers(HeaderUtil.createFailureAlert((String)ENTITY_NAME, (String)"idexists", (String)"A new graph cannot already have an ID"))).body(null);
        }
        String login = SecurityUtils.getCurrentUserLogin();
        User user = this.userRepository.findOneByLogin(login).orElse(null);
        graph.setOwner(user);
        Graph result = this.graphService.save(graph);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/graphs/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/graphs"})
    @Timed
    public ResponseEntity<Graph> updateGraph(@Valid @RequestBody Graph graph) throws URISyntaxException {
        this.log.debug("REST request to update Graph : {}", (Object)graph);
        if (graph.getId() == null) {
            return this.createGraph(graph);
        }
        Graph result = this.graphService.save(graph);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)ENTITY_NAME, (String)graph.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/graphs"})
    @Timed
    public ResponseEntity<List<Graph>> getAllGraphs(Pageable pageable) throws URISyntaxException {
        this.log.debug("REST request to get a page of Graphs");
        Page page = this.graphService.findAll(pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((Page)page, (String)"/api/graphs");
        return new ResponseEntity((Object)page.getContent(), (MultiValueMap)headers, HttpStatus.OK);
    }

    @GetMapping(value={"/graphs/{id}"})
    @Timed
    public ResponseEntity<Graph> getGraph(@PathVariable Long id) {
        this.log.debug("REST request to get Graph : {}", (Object)id);
        Graph graph = this.graphService.findOne(id);
        return ResponseUtil.wrapOrNotFound(Optional.ofNullable(graph));
    }

    @DeleteMapping(value={"/graphs/{id}"})
    @Timed
    public ResponseEntity<Void> deleteGraph(@PathVariable Long id) {
        this.log.debug("REST request to delete Graph : {}", (Object)id);
        this.graphService.delete(id);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityDeletionAlert((String)ENTITY_NAME, (String)id.toString()))).build();
    }

    @GetMapping(value={"/mygraphs"})
    @Timed
    public ResponseEntity<List<Graph>> getMyGraphs() throws URISyntaxException {
        this.log.debug("REST request to get owned and shared graphs");
        String login = SecurityUtils.getCurrentUserLogin();
        List list = this.graphService.findByOwnerIsCurrentUserOrShared(login);
        return new ResponseEntity((Object)list, HttpStatus.OK);
    }
}

