/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain;

import org.powertac.common.TariffSpecification;
import org.powertac.visualizer.domain.Broker;
import org.powertac.visualizer.domain.RetailKPIHolder;

public class Tariff {
    private static long idCounter = 0L;
    private long id = idCounter++;
    private Broker broker;
    private long tariffSpecId;
    private boolean active = true;
    private Long expiration = null;
    private long minDuration = 0L;
    private String powerType;
    private double signupPayment = 0.0;
    private double earlyWithdrawPayment = 0.0;
    private double periodicPayment = 0.0;
    private RetailKPIHolder retailKPIHolder = new RetailKPIHolder();

    protected Tariff() {
    }

    public Tariff(Broker broker, TariffSpecification spec) {
        this.broker = broker;
        this.tariffSpecId = spec.getId();
        this.expiration = spec.getExpiration() == null ? -1L : spec.getExpiration().getMillis();
        this.minDuration = spec.getMinDuration();
        this.powerType = spec.getPowerType().toString();
        this.signupPayment = spec.getSignupPayment();
        this.earlyWithdrawPayment = spec.getEarlyWithdrawPayment();
        this.periodicPayment = spec.getPeriodicPayment();
    }

    public long getTariffSpecId() {
        return this.tariffSpecId;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public long getId() {
        return this.id;
    }

    public boolean isActive() {
        return this.active;
    }

    public Broker getBroker() {
        return this.broker;
    }

    public Long getExpiration() {
        return this.expiration;
    }

    public long getMinDuration() {
        return this.minDuration;
    }

    public String getPowerType() {
        return this.powerType;
    }

    public double getSignupPayment() {
        return this.signupPayment;
    }

    public double getEarlyWithdrawPayment() {
        return this.earlyWithdrawPayment;
    }

    public double getPeriodicPayment() {
        return this.periodicPayment;
    }

    public RetailKPIHolder getRetail() {
        return this.retailKPIHolder;
    }

    public void setRetail(RetailKPIHolder retailKPIHolder) {
        this.retailKPIHolder = retailKPIHolder;
    }

    public static void recycle() {
        idCounter = 1L;
    }
}

