/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.service_ptac;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.powertac.common.interfaces.VisualizerMessageListener;
import org.powertac.logtool.common.NewObjectListener;
import org.powertac.visualizer.service_ptac.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MessageDispatcher
implements VisualizerMessageListener,
NewObjectListener {
    private static Logger log = LoggerFactory.getLogger(MessageDispatcher.class);
    @Autowired
    private ApplicationContext context;
    private HashMap<Class<?>, Set<Object>> registrations;

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        this.registrations = new HashMap();
        this.registerAllHandlers();
    }

    public void receiveMessage(Object message) {
        Class<?> clazz = message.getClass();
        Set targets = (Set)this.registrations.get(clazz);
        if (targets == null) {
            log.trace("no targets for message of type " + clazz.getName());
            return;
        }
        for (Object target : targets) {
            MessageDispatcher.dispatch(target, (String)"handleMessage", (Object[])new Object[]{message});
        }
    }

    public void handleNewObject(Object obj) {
        this.receiveMessage(obj);
    }

    public static Object dispatch(Object target, String methodName, Object ... args) {
        Logger log = LoggerFactory.getLogger((String)target.getClass().getName());
        Object result = null;
        try {
            Class[] classes = new Class[args.length];
            for (int index = 0; index < args.length; ++index) {
                classes[index] = args[index].getClass();
            }
            Method method = target.getClass().getMethod(methodName, classes);
            log.trace("found method " + method);
            result = method.invoke(target, args);
        }
        catch (NoSuchMethodException nsm) {
            log.debug("Could not find exact match: " + nsm.toString());
        }
        catch (InvocationTargetException ite) {
            Throwable thr = ite.getTargetException();
            log.error("Cannot call " + methodName + ": " + thr + "\n");
        }
        catch (Exception ex) {
            log.error("Exception calling message processor: " + ex.toString());
        }
        return result;
    }

    public void registerAllHandlers() {
        Collection handlers = this.context.getBeansOfType(MessageHandler.class).values();
        log.info("Ready to initialize " + handlers.size() + " objects");
        for (MessageHandler handler : handlers) {
            handler.initialize();
            this.registerMessageHandlers((Object)handler, this);
        }
    }

    private void registerMessageHandlers(Object thing, MessageDispatcher router) {
        try {
            thing = this.getTargetObject(thing, MessageHandler.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Class<?> thingClass = thing.getClass();
        Method[] methods = thingClass.getMethods();
        log.info(thingClass.getSimpleName() + " has " + methods.length + " methods");
        Arrays.asList(methods).forEach(method -> log.info(method.getName()));
        for (Method method2 : methods) {
            Class<?>[] args;
            if (!method2.getName().equals("handleMessage") || 1 != (args = method2.getParameterTypes()).length) continue;
            log.info("Register " + thing.getClass().getSimpleName() + ".handleMessage(" + args[0].getSimpleName() + ")");
            router.registerMessageHandler(thing, args[0]);
        }
    }

    private void registerMessageHandler(Object handler, Class<?> messageType) {
        log.info("Registering " + handler.toString() + " for " + messageType.getSimpleName());
        HashSet<Object> reg = (HashSet<Object>)this.registrations.get(messageType);
        if (reg == null) {
            reg = new HashSet<Object>();
            this.registrations.put(messageType, reg);
        }
        reg.add(handler);
    }

    private <T> T getTargetObject(Object proxy, Class<?> targetClass) throws Exception {
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            return (T)this.getTargetObject(((Advised)proxy).getTargetSource().getTarget(), targetClass);
        }
        return (T)proxy;
    }
}

