/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.web.rest;

import com.codahale.metrics.annotation.Timed;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.powertac.visualizer.domain.User;
import org.powertac.visualizer.repository.UserRepository;
import org.powertac.visualizer.service.UserService;
import org.powertac.visualizer.service.dto.UserDTO;
import org.powertac.visualizer.web.rest.util.HeaderUtil;
import org.powertac.visualizer.web.rest.util.PaginationUtil;
import org.powertac.visualizer.web.rest.vm.ManagedUserVM;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class UserResource {
    private final Logger log = LoggerFactory.getLogger(UserResource.class);
    private static final String ENTITY_NAME = "userManagement";
    private final UserRepository userRepository;
    private final UserService userService;

    public UserResource(UserRepository userRepository, UserService userService) {
        this.userRepository = userRepository;
        this.userService = userService;
    }

    @PostMapping(value={"/users"})
    @Timed
    @Secured(value={"ROLE_ADMIN"})
    public ResponseEntity<UserDTO> createUser(@RequestBody ManagedUserVM managedUserVM) throws URISyntaxException {
        this.log.debug("REST request to save User : {}", (Object)managedUserVM);
        if (this.userRepository.findOneByLogin(managedUserVM.getLogin().toLowerCase()).isPresent()) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().headers(HeaderUtil.createFailureAlert((String)ENTITY_NAME, (String)"userexists", (String)"Login already in use"))).body(null);
        }
        User newUser = this.userService.createUser((UserDTO)managedUserVM);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/users/" + newUser.getLogin())).headers(HeaderUtil.createAlert((String)("A user is created with identifier " + newUser.getLogin()), (String)newUser.getLogin()))).body((Object)new UserDTO(newUser));
    }

    @PutMapping(value={"/users"})
    @Timed
    @Secured(value={"ROLE_ADMIN"})
    public ResponseEntity<UserDTO> updateUser(@RequestBody ManagedUserVM managedUserVM) {
        this.log.debug("REST request to update User : {}", (Object)managedUserVM);
        Optional existingUser = this.userRepository.findOneByLogin(managedUserVM.getLogin().toLowerCase());
        if (existingUser.isPresent() && !((User)existingUser.get()).getId().equals(managedUserVM.getId())) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().headers(HeaderUtil.createFailureAlert((String)ENTITY_NAME, (String)"userexists", (String)"Login already in use"))).body(null);
        }
        Optional updatedUser = this.userService.updateUser((UserDTO)managedUserVM);
        return ResponseUtil.wrapOrNotFound((Optional)updatedUser, (HttpHeaders)HeaderUtil.createAlert((String)("A user is updated with identifier " + managedUserVM.getLogin()), (String)managedUserVM.getLogin()));
    }

    @GetMapping(value={"/users"})
    @Timed
    public ResponseEntity<List<UserDTO>> getAllUsers(Pageable pageable) throws URISyntaxException {
        Page page = this.userService.getAllManagedUsers(pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((Page)page, (String)"/api/users");
        return new ResponseEntity((Object)page.getContent(), (MultiValueMap)headers, HttpStatus.OK);
    }

    @GetMapping(value={"/users/{login:^[_'.@A-Za-z0-9-]*$}"})
    @Timed
    public ResponseEntity<UserDTO> getUser(@PathVariable String login) {
        this.log.debug("REST request to get User : {}", (Object)login);
        return ResponseUtil.wrapOrNotFound(this.userService.getUserWithAuthoritiesByLogin(login).map(UserDTO::new));
    }

    @DeleteMapping(value={"/users/{login:^[_'.@A-Za-z0-9-]*$}"})
    @Timed
    @Secured(value={"ROLE_ADMIN"})
    public ResponseEntity<Void> deleteUser(@PathVariable String login) {
        this.log.debug("REST request to delete User: {}", (Object)login);
        this.userService.deleteUser(login);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createAlert((String)("A user is deleted with identifier " + login), (String)login))).build();
    }
}

