/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.web.rest.errors;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import org.apache.commons.io.FileExistsException;
import org.powertac.visualizer.web.rest.errors.CustomParameterizedException;
import org.powertac.visualizer.web.rest.errors.ErrorVM;
import org.powertac.visualizer.web.rest.errors.ParameterizedErrorVM;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartException;

@ControllerAdvice
public class ExceptionTranslator {
    @ExceptionHandler(value={ConcurrencyFailureException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ResponseBody
    public ErrorVM processConcurencyError(ConcurrencyFailureException ex) {
        return new ErrorVM("error.concurrencyFailure");
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorVM processValidationError(MethodArgumentNotValidException ex) {
        BindingResult result = ex.getBindingResult();
        List fieldErrors = result.getFieldErrors();
        return this.processFieldErrors(fieldErrors);
    }

    private ErrorVM processFieldErrors(List<FieldError> fieldErrors) {
        ErrorVM dto = new ErrorVM("error.validation");
        for (FieldError fieldError : fieldErrors) {
            dto.add(fieldError.getObjectName(), fieldError.getField(), fieldError.getCode());
        }
        return dto;
    }

    @ExceptionHandler(value={CustomParameterizedException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ParameterizedErrorVM processParameterizedValidationError(CustomParameterizedException ex) {
        return ex.getErrorVM();
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public ErrorVM processAccessDeniedException(AccessDeniedException e) {
        return new ErrorVM("error.accessDenied", e.getMessage());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ErrorVM processIllegalArgumentException(IllegalArgumentException e) {
        return new ErrorVM("error.illegalArgument", e.getMessage());
    }

    @ExceptionHandler(value={FileNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public ErrorVM processFileNotFoundException(FileNotFoundException e) {
        return new ErrorVM("error.fileNotFound", e.getMessage());
    }

    @ExceptionHandler(value={IOException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ErrorVM processIOException(IOException e) {
        return new ErrorVM("error.ioException", e.getMessage());
    }

    @ExceptionHandler(value={MalformedURLException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorVM processMalformedURLException(MalformedURLException e) {
        return new ErrorVM("error.malformedUrl", e.getMessage());
    }

    @ExceptionHandler(value={FileExistsException.class})
    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    @ResponseBody
    public ErrorVM processFileExistsException(FileExistsException e) {
        return new ErrorVM("error.fileExists", e.getMessage());
    }

    @ExceptionHandler(value={MultipartException.class})
    @ResponseStatus(value=HttpStatus.PAYLOAD_TOO_LARGE)
    @ResponseBody
    public ErrorVM processMultipartException(MultipartException e) {
        return new ErrorVM("error.fileTooLarge", e.getMessage());
    }

    @ExceptionHandler(value={SecurityException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public ErrorVM processSecurityException(SecurityException e) {
        return new ErrorVM("error.forbidden", e.getMessage());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    public ErrorVM processMethodNotSupportedException(HttpRequestMethodNotSupportedException exception) {
        return new ErrorVM("error.methodNotSupported", exception.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ErrorVM> processRuntimeException(Exception ex) {
        ErrorVM errorVM;
        ResponseEntity.BodyBuilder builder;
        ResponseStatus responseStatus = (ResponseStatus)AnnotationUtils.findAnnotation(ex.getClass(), ResponseStatus.class);
        if (responseStatus != null) {
            builder = ResponseEntity.status((HttpStatus)responseStatus.value());
            errorVM = new ErrorVM("error." + responseStatus.value().value(), responseStatus.reason() + ": " + ex.getMessage());
        } else {
            builder = ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR);
            errorVM = new ErrorVM("error.internalServerError", "Internal server error: " + ex.getMessage());
        }
        return builder.body((Object)errorVM);
    }
}

