/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.web.rest;

import com.codahale.metrics.annotation.Timed;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.powertac.visualizer.domain.PersistentToken;
import org.powertac.visualizer.repository.PersistentTokenRepository;
import org.powertac.visualizer.repository.UserRepository;
import org.powertac.visualizer.security.SecurityUtils;
import org.powertac.visualizer.service.UserService;
import org.powertac.visualizer.service.dto.UserDTO;
import org.powertac.visualizer.web.rest.vm.ManagedUserVM;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class AccountResource {
    private final Logger log = LoggerFactory.getLogger(AccountResource.class);
    private final UserRepository userRepository;
    private final UserService userService;
    private final PersistentTokenRepository persistentTokenRepository;

    public AccountResource(UserRepository userRepository, UserService userService, PersistentTokenRepository persistentTokenRepository) {
        this.userRepository = userRepository;
        this.userService = userService;
        this.persistentTokenRepository = persistentTokenRepository;
    }

    @PostMapping(path={"/register"}, produces={"application/json", "text/plain"})
    @Timed
    public ResponseEntity<String> registerAccount(@Valid @RequestBody ManagedUserVM managedUserVM) {
        HttpHeaders textPlainHeaders = new HttpHeaders();
        textPlainHeaders.setContentType(MediaType.TEXT_PLAIN);
        return this.userRepository.findOneByLogin(managedUserVM.getLogin().toLowerCase()).map(user -> new ResponseEntity((Object)"login already in use", (MultiValueMap)textPlainHeaders, HttpStatus.BAD_REQUEST)).orElseGet(() -> {
            this.userService.createUser(managedUserVM.getLogin(), managedUserVM.getPassword(), managedUserVM.getFirstName(), managedUserVM.getLastName(), managedUserVM.getLangKey());
            return new ResponseEntity(HttpStatus.CREATED);
        });
    }

    @GetMapping(value={"/authenticate"})
    @Timed
    public String isAuthenticated(HttpServletRequest request) {
        this.log.debug("REST request to check if the current user is authenticated");
        return request.getRemoteUser();
    }

    @GetMapping(value={"/account"})
    @Timed
    public ResponseEntity<UserDTO> getAccount() {
        return Optional.ofNullable(this.userService.getUserWithAuthorities()).map(user -> new ResponseEntity((Object)new UserDTO(user), HttpStatus.OK)).orElse(new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR));
    }

    @PostMapping(value={"/account"})
    @Timed
    public ResponseEntity<String> saveAccount(@Valid @RequestBody UserDTO userDTO) {
        return this.userRepository.findOneByLogin(SecurityUtils.getCurrentUserLogin()).map(u -> {
            this.userService.updateUser(userDTO.getFirstName(), userDTO.getLastName(), userDTO.getLangKey());
            return new ResponseEntity(HttpStatus.OK);
        }).orElseGet(() -> new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR));
    }

    @PostMapping(path={"/account/change_password"}, produces={"text/plain"})
    @Timed
    public ResponseEntity<String> changePassword(@RequestBody String password) {
        if (!this.checkPasswordLength(password)) {
            return new ResponseEntity((Object)"Incorrect password", HttpStatus.BAD_REQUEST);
        }
        this.userService.changePassword(password);
        return new ResponseEntity(HttpStatus.OK);
    }

    @GetMapping(value={"/account/sessions"})
    @Timed
    public ResponseEntity<List<PersistentToken>> getCurrentSessions() {
        return this.userRepository.findOneByLogin(SecurityUtils.getCurrentUserLogin()).map(user -> new ResponseEntity((Object)this.persistentTokenRepository.findByUser(user), HttpStatus.OK)).orElse(new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR));
    }

    @DeleteMapping(value={"/account/sessions/{series}"})
    @Timed
    public void invalidateSession(@PathVariable String series) throws UnsupportedEncodingException {
        String decodedSeries = URLDecoder.decode(series, "UTF-8");
        this.userRepository.findOneByLogin(SecurityUtils.getCurrentUserLogin()).ifPresent(u -> this.persistentTokenRepository.findByUser(u).stream().filter(persistentToken -> StringUtils.equals((CharSequence)persistentToken.getSeries(), (CharSequence)decodedSeries)).findAny().ifPresent(t -> this.persistentTokenRepository.delete((Serializable)((Object)decodedSeries))));
    }

    private boolean checkPasswordLength(String password) {
        return !StringUtils.isEmpty((CharSequence)password) && password.length() >= 4 && password.length() <= 100;
    }
}

