/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.domain;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Proxy;
import org.powertac.visualizer.domain.User;
import org.powertac.visualizer.domain.enumeration.GraphType;

@Entity
@Table(name="graph")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Proxy(lazy=false)
public class Graph
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull
    @Size(min=1, max=255)
    @Column(name="name", length=255, nullable=false)
    private @NotNull @Size(min=1, max=255) String name;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="type", nullable=false)
    private GraphType type;
    @NotNull
    @Column(name="shared", nullable=false)
    private Boolean shared;
    @ManyToOne
    private User owner;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GraphType getType() {
        return this.type;
    }

    public void setType(GraphType type) {
        this.type = type;
    }

    public Boolean isShared() {
        return this.shared;
    }

    public void setShared(Boolean shared) {
        this.shared = shared;
    }

    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User user) {
        this.owner = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Graph graph = (Graph)o;
        if (graph.id == null || this.id == null) {
            return false;
        }
        return Objects.equals(this.id, graph.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public String toString() {
        return "Graph{id=" + this.id + ", name='" + this.name + "', type='" + this.type + "', shared='" + this.shared + "'" + '}';
    }
}

