/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.security;

import io.github.jhipster.config.JHipsterProperties;
import java.time.LocalDate;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.powertac.visualizer.domain.PersistentToken;
import org.powertac.visualizer.repository.PersistentTokenRepository;
import org.powertac.visualizer.repository.UserRepository;
import org.powertac.visualizer.service.util.RandomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.rememberme.AbstractRememberMeServices;
import org.springframework.security.web.authentication.rememberme.CookieTheftException;
import org.springframework.security.web.authentication.rememberme.InvalidCookieException;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationException;
import org.springframework.stereotype.Service;

@Service
public class PersistentTokenRememberMeServices
extends AbstractRememberMeServices {
    private final Logger log = LoggerFactory.getLogger(PersistentTokenRememberMeServices.class);
    private static final int TOKEN_VALIDITY_DAYS = 31;
    private static final int TOKEN_VALIDITY_SECONDS = 2678400;
    private final PersistentTokenRepository persistentTokenRepository;
    private final UserRepository userRepository;

    public PersistentTokenRememberMeServices(JHipsterProperties jHipsterProperties, UserDetailsService userDetailsService, PersistentTokenRepository persistentTokenRepository, UserRepository userRepository) {
        super(jHipsterProperties.getSecurity().getRememberMe().getKey(), userDetailsService);
        this.persistentTokenRepository = persistentTokenRepository;
        this.userRepository = userRepository;
    }

    protected UserDetails processAutoLoginCookie(String[] cookieTokens, HttpServletRequest request, HttpServletResponse response) {
        PersistentToken token = this.getPersistentToken(cookieTokens);
        String login = token.getUser().getLogin();
        this.log.debug("Refreshing persistent login token for user '{}', series '{}'", (Object)login, (Object)token.getSeries());
        token.setTokenDate(LocalDate.now());
        token.setTokenValue(RandomUtil.generateTokenData());
        token.setIpAddress(request.getRemoteAddr());
        token.setUserAgent(request.getHeader("User-Agent"));
        try {
            this.persistentTokenRepository.saveAndFlush((Object)token);
            this.addCookie(token, request, response);
        }
        catch (DataAccessException e) {
            this.log.error("Failed to update token: ", (Throwable)e);
            throw new RememberMeAuthenticationException("Autologin failed due to data access problem", (Throwable)e);
        }
        return this.getUserDetailsService().loadUserByUsername(login);
    }

    protected void onLoginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        String login = successfulAuthentication.getName();
        this.log.debug("Creating new persistent login for user {}", (Object)login);
        PersistentToken token = this.userRepository.findOneByLogin(login).map(u -> {
            PersistentToken t = new PersistentToken();
            t.setSeries(RandomUtil.generateSeriesData());
            t.setUser(u);
            t.setTokenValue(RandomUtil.generateTokenData());
            t.setTokenDate(LocalDate.now());
            t.setIpAddress(request.getRemoteAddr());
            t.setUserAgent(request.getHeader("User-Agent"));
            return t;
        }).orElseThrow(() -> new UsernameNotFoundException("User " + login + " was not found in the database"));
        try {
            this.persistentTokenRepository.saveAndFlush((Object)token);
            this.addCookie(token, request, response);
        }
        catch (DataAccessException e) {
            this.log.error("Failed to save persistent token ", (Throwable)e);
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        String rememberMeCookie = this.extractRememberMeCookie(request);
        if (rememberMeCookie != null && rememberMeCookie.length() != 0) {
            try {
                String[] cookieTokens = this.decodeCookie(rememberMeCookie);
                PersistentToken token = this.getPersistentToken(cookieTokens);
                this.persistentTokenRepository.delete((Object)token);
            }
            catch (InvalidCookieException ice) {
                this.log.info("Invalid cookie, no persistent token could be deleted", (Throwable)ice);
            }
            catch (RememberMeAuthenticationException rmae) {
                this.log.debug("No persistent token found, so no token could be deleted", (Throwable)rmae);
            }
        }
        super.logout(request, response, authentication);
    }

    private PersistentToken getPersistentToken(String[] cookieTokens) {
        if (cookieTokens.length != 2) {
            throw new InvalidCookieException("Cookie token did not contain 2 tokens, but contained '" + Arrays.asList(cookieTokens) + "'");
        }
        String presentedSeries = cookieTokens[0];
        String presentedToken = cookieTokens[1];
        PersistentToken token = (PersistentToken)this.persistentTokenRepository.getOne((Object)presentedSeries);
        if (token == null) {
            throw new RememberMeAuthenticationException("No persistent token found for series id: " + presentedSeries);
        }
        this.log.info("presentedToken={} / tokenValue={}", (Object)presentedToken, (Object)token.getTokenValue());
        if (!presentedToken.equals(token.getTokenValue())) {
            this.persistentTokenRepository.delete((Object)token);
            throw new CookieTheftException("Invalid remember-me token (Series/token) mismatch. Implies previous cookie theft attack.");
        }
        if (token.getTokenDate().plusDays(31L).isBefore(LocalDate.now())) {
            this.persistentTokenRepository.delete((Object)token);
            throw new RememberMeAuthenticationException("Remember-me login has expired");
        }
        return token;
    }

    private void addCookie(PersistentToken token, HttpServletRequest request, HttpServletResponse response) {
        this.setCookie(new String[]{token.getSeries(), token.getTokenValue()}, 2678400, request, response);
    }
}

