/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.service;

import java.util.List;
import org.powertac.visualizer.domain.Chart;
import org.powertac.visualizer.repository.ChartRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ChartService {
    private final Logger log = LoggerFactory.getLogger(ChartService.class);
    private final ChartRepository chartRepository;

    public ChartService(ChartRepository chartRepository) {
        this.chartRepository = chartRepository;
    }

    public Chart save(Chart chart) {
        this.log.debug("Request to save Chart : {}", (Object)chart);
        Chart result = (Chart)this.chartRepository.save((Object)chart);
        return result;
    }

    @Transactional(readOnly=true)
    public Page<Chart> findAll(Pageable pageable) {
        this.log.debug("Request to get all Charts");
        Page result = this.chartRepository.findAll(pageable);
        return result;
    }

    @Transactional(readOnly=true)
    public List<Chart> findByOwnerIsCurrentUserOrShared(String login) {
        this.log.debug("Request to get all owned and shared Charts");
        List result = this.chartRepository.findByOwnerIsCurrentUserOrShared(login);
        return result;
    }

    @Transactional(readOnly=true)
    public Chart getOne(Long id) {
        this.log.debug("Request to get Chart : {}", (Object)id);
        Chart chart = this.chartRepository.findOneWithEagerRelationships(id);
        return chart;
    }

    public void delete(Chart chart) {
        this.log.debug("Request to delete Chart : {}", (Object)chart);
        this.chartRepository.delete((Object)chart);
    }
}

