/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.service;

import java.util.List;
import org.powertac.visualizer.domain.Graph;
import org.powertac.visualizer.repository.GraphRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GraphService {
    private final Logger log = LoggerFactory.getLogger(GraphService.class);
    private final GraphRepository graphRepository;

    public GraphService(GraphRepository graphRepository) {
        this.graphRepository = graphRepository;
    }

    public Graph save(Graph graph) {
        this.log.debug("Request to save Graph : {}", (Object)graph);
        Graph result = (Graph)this.graphRepository.save((Object)graph);
        return result;
    }

    @Transactional(readOnly=true)
    public Page<Graph> findAll(Pageable pageable) {
        this.log.debug("Request to get all Graphs");
        Page result = this.graphRepository.findAll(pageable);
        return result;
    }

    @Transactional(readOnly=true)
    public List<Graph> findByOwnerIsCurrentUserOrShared(String login) {
        this.log.debug("Request to get all owned and shared Graphs");
        List result = this.graphRepository.findByOwnerIsCurrentUserOrShared(login);
        return result;
    }

    @Transactional(readOnly=true)
    public Graph getOne(Long id) {
        this.log.debug("Request to get Graph : {}", (Object)id);
        Graph graph = (Graph)this.graphRepository.getOne((Object)id);
        return graph;
    }

    public void delete(Graph graph) {
        this.log.debug("Request to delete Graph : {}", (Object)graph);
        this.graphRepository.delete((Object)graph);
    }
}

