/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.visualizer.service;

import java.util.List;
import org.powertac.visualizer.domain.View;
import org.powertac.visualizer.repository.ViewRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ViewService {
    private final Logger log = LoggerFactory.getLogger(ViewService.class);
    private final ViewRepository viewRepository;

    public ViewService(ViewRepository viewRepository) {
        this.viewRepository = viewRepository;
    }

    public View save(View view) {
        this.log.debug("Request to save View : {}", (Object)view);
        View result = (View)this.viewRepository.save((Object)view);
        return result;
    }

    @Transactional(readOnly=true)
    public Page<View> findAll(Pageable pageable) {
        this.log.debug("Request to get all Views");
        Page result = this.viewRepository.findAll(pageable);
        return result;
    }

    @Transactional(readOnly=true)
    public List<View> findByOwnerIsCurrentUserOrShared(String login) {
        this.log.debug("Request to get all owned and shared Graphs");
        List result = this.viewRepository.findByOwnerIsCurrentUserOrShared(login);
        return result;
    }

    @Transactional(readOnly=true)
    public View getOne(Long id) {
        this.log.debug("Request to get View : {}", (Object)id);
        View view = (View)this.viewRepository.getOne((Object)id);
        return view;
    }

    public void delete(View view) {
        this.log.debug("Request to delete View : {}", (Object)view);
        this.viewRepository.delete((Object)view);
    }
}

